/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.InSimTime;

public class LapTimeResponse
extends PlayerResponse {
    private InSimTime time;
    private InSimTime totalTime;
    private int lapsDone;
    private int flags;
    private int penalty;
    private int numberPitStops;

    LapTimeResponse() {
        super(PacketType.LAP);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.setTime(new InSimTime(buffer));
        this.totalTime = new InSimTime(buffer);
        this.setLapsDone(buffer.getShort());
        this.setFlags(buffer.getShort());
        buffer.position(buffer.position() + 1);
        this.setPenalty(buffer.get());
        this.setNumberPitStops(buffer.get());
        buffer.position(buffer.position() + 1);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", Laps done: " + this.getLapsDone() + ", Flags: " + this.getFlags() + ", Penalty: " + this.getPenalty() + ", Number of Pitstops: " + this.getNumberPitStops() + ", Time: " + this.getTime() + ", Total Time: " + this.totalTime;
    }

    public InSimTime getTime() {
        return this.time;
    }

    public void setTime(InSimTime time) {
        this.time = time;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getLapsDone() {
        return this.lapsDone;
    }

    public void setLapsDone(int lapsDone) {
        this.lapsDone = lapsDone;
    }

    public int getNumberPitStops() {
        return this.numberPitStops;
    }

    public void setNumberPitStops(int numberPitStops) {
        this.numberPitStops = numberPitStops;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) {
        this.penalty = penalty;
    }

    public InSimTime getTotalTime() {
        return this.totalTime;
    }
}

