/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.InSimTime;

public class FinishedRaceResponse
extends PlayerResponse {
    private InSimTime totalTime;
    private InSimTime bestLap;
    private byte numberOfStops;
    private byte confirmationFlags;
    private int lapsDone;
    private int playerFlags;

    public FinishedRaceResponse() {
        super(PacketType.FINISHED_RACE);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.totalTime = new InSimTime(buffer);
        this.bestLap = new InSimTime(buffer);
        buffer.position(buffer.position() + 1);
        this.numberOfStops = buffer.get();
        this.confirmationFlags = buffer.get();
        buffer.position(buffer.position() + 1);
        this.lapsDone = buffer.getShort();
        this.playerFlags = buffer.getShort();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", totalTime: " + this.totalTime + ", bestLap: " + this.bestLap + ", numberOfStops: " + this.numberOfStops + ", confirmationFlags: " + this.confirmationFlags + ", lapsDone " + this.lapsDone + ", playerFlags" + this.playerFlags;
    }

    public FinishedRaceResponse(PacketType type) {
        super(PacketType.FINISHED_RACE);
    }

    public void setBestLap(InSimTime bestLap) {
        this.bestLap = bestLap;
    }

    public void setConfirmationFlags(byte confirmationFlags) {
        this.confirmationFlags = confirmationFlags;
    }

    public void setLapsDone(int lapsDone) {
        this.lapsDone = lapsDone;
    }

    public void setNumberOfStops(byte numberOfStops) {
        this.numberOfStops = numberOfStops;
    }

    public void setPlayerFlags(int playerFlags) {
        this.playerFlags = playerFlags;
    }

    public void setTotalTime(InSimTime totalTime) {
        this.totalTime = totalTime;
    }
}

