/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.InSimVector;

public class CameraPositionResponse
extends InSimResponse {
    public static final String TYPE = "CPP";
    public static final int ISS_SHIFTU = 8;
    public static final int ISS_SHIFTU_HIGH = 16;
    public static final int ISS_SHIFTU_FOLLOW = 32;
    public static final int ISS_VIEW_OVERRIDE = 8192;
    private InSimVector position;
    private short heading;
    private short pitch;
    private short roll;
    private byte playerIndex;
    private byte cameraType;
    private float fov;
    private short time;
    private short flags;

    CameraPositionResponse() {
        super(PacketType.CAMERA_POSITION);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        buffer.position(buffer.position() + 1);
        this.setPosition(new InSimVector(buffer));
        this.setHeading(buffer.getShort());
        this.setPitch(buffer.getShort());
        this.setRoll(buffer.getShort());
        this.setPlayerIndex(buffer.get());
        this.setCameraType(buffer.get());
        this.setFov(buffer.getFloat());
        this.setTime(buffer.getShort());
        this.setFlags(buffer.getShort());
    }

    @Override
    public String toString() {
        String retval = super.toString();
        retval = String.valueOf(retval) + "Position: " + this.getPosition() + "\n";
        retval = String.valueOf(retval) + "Heading: " + this.getHeading() + "\n";
        retval = String.valueOf(retval) + "Pitch: " + this.getPitch() + "\n";
        retval = String.valueOf(retval) + "Roll: " + this.getRoll() + "\n";
        retval = String.valueOf(retval) + "Player index: " + this.getPlayerIndex() + "\n";
        retval = String.valueOf(retval) + "Camera type: " + this.getCameraType() + "\n";
        retval = String.valueOf(retval) + "Field of view: " + this.getFov() + "\n";
        retval = String.valueOf(retval) + "Time: " + this.getTime() + "\n";
        retval = String.valueOf(retval) + "Flags: " + this.getFlags() + "\n";
        return retval;
    }

    public byte getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(byte cameraType) {
        this.cameraType = cameraType;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public float getFov() {
        return this.fov;
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public short getHeading() {
        return this.heading;
    }

    public void setHeading(short heading) {
        this.heading = heading;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    public byte getPlayerIndex() {
        return this.playerIndex;
    }

    public void setPlayerIndex(byte playerIndex) {
        this.playerIndex = playerIndex;
    }

    public InSimVector getPosition() {
        return this.position;
    }

    public void setPosition(InSimVector position) {
        this.position = position;
    }

    public short getRoll() {
        return this.roll;
    }

    public void setRoll(short roll) {
        this.roll = roll;
    }

    public short getTime() {
        return this.time;
    }

    public void setTime(short time) {
        this.time = time;
    }
}

