/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.response.CameraPositionResponse;
import net.sf.jinsim.types.InSimVector;

public class SetDirectCameraRequest
extends InSimRequest {
    public static final short ISS_SHIFTU = 8;
    public static final short ISS_SHIFTU_HIGH = 16;
    public static final short ISS_SHIFTU_FOLLOW = 32;
    public static final short ISS_VIEW_OVERRIDE = 8192;
    private InSimVector position = new InSimVector(0, 0, 0);
    private short heading;
    private short pitch;
    private short roll;
    private byte playerIndex;
    private byte cameraType;
    private float fov;
    private short time;
    private short flags;

    public SetDirectCameraRequest() {
        super(PacketType.CAMERA_POSITION, 32);
    }

    public SetDirectCameraRequest(CameraPositionResponse cameraResponse) {
        this();
        this.setCameraType(cameraResponse.getCameraType());
        this.setFlags(cameraResponse.getFlags());
        this.setFov(cameraResponse.getFov());
        this.setHeading(cameraResponse.getHeading());
        this.setPitch(cameraResponse.getPitch());
        this.setPlayerIndex(cameraResponse.getPlayerIndex());
        this.setPosition(cameraResponse.getPosition());
        this.setRoll(cameraResponse.getRoll());
        this.setTime(cameraResponse.getTime());
    }

    @Override
    public void assemble(ByteBuffer data) {
        super.assemble(data);
        data.put((byte)0);
        data.putInt(this.getPosition().getX());
        data.putInt(this.getPosition().getY());
        data.putInt(this.getPosition().getZ());
        data.putShort(this.getHeading());
        data.putShort(this.getPitch());
        data.putShort(this.getRoll());
        data.put(this.getPlayerIndex());
        data.put(this.getCameraType());
        data.putFloat(this.getFov());
        data.putShort(this.getTime());
        data.putShort(this.getFlags());
    }

    @Override
    public String toString() {
        String retval = super.toString();
        retval = String.valueOf(retval) + "Position: " + this.getPosition() + "\n";
        retval = String.valueOf(retval) + "Heading: " + this.getHeading() + "\n";
        retval = String.valueOf(retval) + "Pitch: " + this.getPitch() + "\n";
        retval = String.valueOf(retval) + "Roll: " + this.getRoll() + "\n";
        retval = String.valueOf(retval) + "Player index: " + this.getPlayerIndex() + "\n";
        retval = String.valueOf(retval) + "Camera type: " + this.getCameraType() + "\n";
        retval = String.valueOf(retval) + "Field of view: " + this.getFov() + "\n";
        retval = String.valueOf(retval) + "Time: " + this.getTime() + "\n";
        retval = String.valueOf(retval) + "Flags: " + this.getFlags() + "\n";
        return retval;
    }

    public byte getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(byte cameraType) {
        this.cameraType = cameraType;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public float getFov() {
        return this.fov;
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public short getHeading() {
        return this.heading;
    }

    public void setHeading(short heading) {
        this.heading = heading;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    public byte getPlayerIndex() {
        return this.playerIndex;
    }

    public void setPlayerIndex(byte playerIndex) {
        this.playerIndex = playerIndex;
    }

    public InSimVector getPosition() {
        return this.position;
    }

    public void setPosition(InSimVector position) {
        this.position = position;
    }

    public short getRoll() {
        return this.roll;
    }

    public void setRoll(short roll) {
        this.roll = roll;
    }

    public short getTime() {
        return this.time;
    }

    public void setTime(short time) {
        this.time = time;
    }
}

