/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.request.InSimRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ButtonRequest
extends InSimRequest {
    private static Log log = LogFactory.getLog(ButtonRequest.class);
    private static final int TEXT_LENGTH = 240;
    public static byte BUTTON_STYLE_LIGHT_GREY = 0;
    public static byte BUTTON_STYLE_YELLOW = 1;
    public static byte BUTTON_STYLE_BLACK = (byte)2;
    public static byte BUTTON_STYLE_WHITE = (byte)3;
    public static byte BUTTON_STYLE_GREEN = (byte)4;
    public static byte BUTTON_STYLE_RED = (byte)5;
    public static byte BUTTON_STYLE_BLUE = (byte)6;
    public static byte BUTTON_STYLE_GREY = (byte)7;
    public static byte BUTTON_STYLE_CLICK = (byte)8;
    public static byte BUTTON_STYLE_LIGHT = (byte)16;
    public static byte BUTTON_STYLE_DARK = (byte)32;
    public static byte BUTTON_STYLE_LEFT = (byte)64;
    public static byte BUTTON_STYLE_RIGHT = (byte)-128;
    private byte connectionId;
    private byte clickId;
    private byte inst;
    private int buttonStyle;
    private byte typeIn;
    private byte left;
    private byte top;
    private byte width;
    private byte height;
    private String text;

    public ButtonRequest() {
        super(PacketType.BUTTON, 252);
    }

    @Override
    public void assemble(ByteBuffer buffer) {
        int textLength = (this.text.length() / 4 + 1) * 4;
        this.size = textLength + 12;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Button buffer size: " + this.size));
        }
        super.assemble(buffer);
        buffer.put(this.connectionId);
        buffer.put(this.clickId);
        buffer.put(this.inst);
        buffer.put((byte)this.buttonStyle);
        buffer.put(this.typeIn);
        buffer.put(this.left);
        buffer.put(this.top);
        buffer.put(this.width);
        buffer.put(this.height);
        if (textLength > 240) {
            textLength = 240;
        }
        this.assembleString(buffer, this.text, textLength);
    }

    public void setButtonStyle(int buttonStyle) {
        this.buttonStyle = buttonStyle;
    }

    public void setClickId(byte clickId) {
        this.clickId = clickId;
    }

    public void setConnectionId(byte connectionId) {
        this.connectionId = connectionId;
    }

    public void setHeight(byte height) {
        this.height = height;
    }

    public void setInst(byte inst) {
        this.inst = inst;
    }

    public void setLeft(byte left) {
        this.left = left;
    }

    public void setTop(byte top) {
        this.top = top;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTypeIn(byte typeIn) {
        this.typeIn = typeIn;
    }

    public void setWidth(byte width) {
        this.width = width;
    }
}

