/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.speedometer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.OutGaugeResponse;

public class SpeedometerPanel
extends JPanel
implements InSimListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage speedometerImage;
    private BufferedImage needleImage;
    private double speed;

    public SpeedometerPanel(String hostname, int port, String password) throws IOException {
        SimpleClient client = new SimpleClient();
        client.addListener(this);
        client.connect(new UDPChannel(hostname, port), password, "Speedometer", (short)0, 0, port + 1);
        client.enableOutGauge(1);
        this.speedometerImage = ImageIO.read(new File("resources/speedometer.jpg"));
        this.needleImage = ImageIO.read(new File("resources/needle.png"));
        Dimension size = new Dimension(this.speedometerImage.getWidth(), this.speedometerImage.getHeight());
        this.setSize(size);
        this.setPreferredSize(size);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.speedometerImage, 0, 0, null);
        double degreesRotation = 1.2272727272727273 * this.speed + 90.0;
        double radiansToRotate = Math.toRadians(degreesRotation);
        AffineTransform savedTransform = g2.getTransform();
        g2.rotate(radiansToRotate, this.speedometerImage.getWidth() / 2, this.speedometerImage.getHeight() / 2);
        g2.drawImage((Image)this.needleImage, this.speedometerImage.getWidth() / 2, this.speedometerImage.getHeight() / 2, null);
        g2.setTransform(savedTransform);
    }

    @Override
    public void packetReceived(InSimResponse response) {
        if (response instanceof OutGaugeResponse) {
            OutGaugeResponse ogResponse = (OutGaugeResponse)response;
            this.speed = (double)ogResponse.getSpeed() * 2.2360248447205;
            this.repaint();
        }
    }
}

