/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.raceclient;

import java.io.IOException;
import net.sf.jinsim.Client;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.examples.raceclient.PrintEventsClient;
import net.sf.jinsim.request.InitRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;

public class Main
implements InSimListener {
    private Client client;
    String hostname;
    int port;
    String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    public void run() {
        try {
            try {
                TCPChannel channel = new TCPChannel(this.hostname, this.port);
                this.client = new PrintEventsClient();
                this.client.connect(channel, this.adminPassword, "RaceClient", InitRequest.RECEIVE_MULTI_CAR_INFO, 200, 0);
                while (true) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void packetReceived(InSimResponse response) {
        if (response instanceof MessageResponse) {
            MessageResponse messageResponse = (MessageResponse)response;
            System.out.println(messageResponse.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.examples.console.Main <hostname> <port> <admin password>");
        }
    }
}

