/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.helloworld;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.MessageRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;

public class Main
implements InSimListener {
    private SimpleClient client;
    String hostname;
    int port;
    String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    public void run() {
        try {
            try {
                this.client = new SimpleClient();
                UDPChannel channel = new UDPChannel(this.hostname, this.port);
                this.client.addListener(this);
                this.client.connect(channel, this.adminPassword, "HelloWorldTest");
                MessageRequest msgRequest = new MessageRequest();
                msgRequest.setMessage("Hello World!");
                this.client.send(msgRequest);
                this.client.send(new TinyRequest(Tiny.PING));
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void packetReceived(InSimResponse response) {
        if (response instanceof MessageResponse) {
            MessageResponse msgResponse = (MessageResponse)response;
            System.out.println("Driver: " + msgResponse.getDriverName() + " says: " + msgResponse.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.examples.console.Main <hostname> <port> <admin password>");
        }
    }
}

