/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.console;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.Small;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.MessageRequest;
import net.sf.jinsim.request.ScreenModeRequest;
import net.sf.jinsim.request.SmallRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;

public class Main
implements InSimListener {
    private SimpleClient client;
    String hostname;
    int port;
    String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    public void run() {
        try {
            try {
                this.client = new SimpleClient();
                this.client.addListener(this);
                this.client.connect(new UDPChannel(this.hostname, this.port), this.adminPassword, "console");
                ScreenModeRequest modeRequest = new ScreenModeRequest();
                modeRequest.setHeight(0);
                modeRequest.setWidth(0);
                this.client.send(modeRequest);
                TinyRequest stateRequest = new TinyRequest(Tiny.SEND_STATE_INFO);
                this.client.send(stateRequest);
                this.client.send(new MessageRequest("/?"));
                this.client.send(new MessageRequest("^1Red, ^7White and  ^4Blue"));
                this.client.send(new SmallRequest(Small.START_SENDING_GAUGES, 1));
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void packetReceived(InSimResponse response) {
        System.out.println(response.toString());
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.examples.console.Main <hostname> <port> <admin password>");
        }
    }
}

