/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.camera;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.SetDirectCameraRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.CameraPositionResponse;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.InSimVector;

public class CameraControlPanel
extends JPanel
implements InSimListener {
    private static final long serialVersionUID = 1L;
    private SetDirectCameraRequest camera;
    final JSlider headingSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    final JSlider pitchSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    final JSlider rollSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    long lastupdate;
    private SimpleClient client;

    public CameraControlPanel(String hostname, int port, String adminPassword) throws IOException {
        this.setLayout(new BoxLayout(this, 1));
        this.client = new SimpleClient();
        this.client.addListener(this);
        this.client.connect(new UDPChannel(hostname, port), adminPassword, "Camera");
        TinyRequest setStateRequest = new TinyRequest(Tiny.SEND_STATE_INFO);
        this.client.send(setStateRequest);
        JPanel cameraControlPanel = new JPanel();
        cameraControlPanel.setLayout(new BoxLayout(cameraControlPanel, 1));
        JPanel headingPanel = new JPanel();
        headingPanel.setLayout(new BoxLayout(headingPanel, 0));
        this.headingSlider.setEnabled(false);
        this.headingSlider.setPaintLabels(true);
        this.headingSlider.setPaintTicks(true);
        this.headingSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.headingSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.headingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (CameraControlPanel.this.camera == null || System.currentTimeMillis() - CameraControlPanel.this.lastupdate < 100L) {
                    return;
                }
                CameraControlPanel.this.lastupdate = System.currentTimeMillis();
                CameraControlPanel.this.camera.setHeading((short)(source.getValue() * -1));
                try {
                    CameraControlPanel.this.client.send(CameraControlPanel.this.camera);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        headingPanel.add(this.headingSlider);
        headingPanel.add(new JLabel("Heading"));
        cameraControlPanel.add(headingPanel);
        JPanel pitchPanel = new JPanel();
        pitchPanel.setLayout(new BoxLayout(pitchPanel, 0));
        this.pitchSlider.setEnabled(false);
        this.pitchSlider.setPaintLabels(true);
        this.pitchSlider.setPaintTicks(true);
        this.pitchSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.pitchSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.pitchSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (CameraControlPanel.this.camera == null) {
                    return;
                }
                CameraControlPanel.this.camera.setPitch((short)(source.getValue() * -1));
                try {
                    CameraControlPanel.this.client.send(CameraControlPanel.this.camera);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        pitchPanel.add(this.pitchSlider);
        pitchPanel.add(new JLabel("Pitch"));
        cameraControlPanel.add(pitchPanel);
        JPanel rollPanel = new JPanel();
        rollPanel.setLayout(new BoxLayout(rollPanel, 0));
        this.rollSlider.setEnabled(false);
        this.rollSlider.setPaintLabels(true);
        this.rollSlider.setPaintTicks(true);
        this.rollSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.rollSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.rollSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (CameraControlPanel.this.camera == null) {
                    return;
                }
                CameraControlPanel.this.camera.setRoll((short)(source.getValue() * -1));
                try {
                    CameraControlPanel.this.client.send(CameraControlPanel.this.camera);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        rollPanel.add(this.rollSlider);
        rollPanel.add(new JLabel("Roll"));
        cameraControlPanel.add(rollPanel);
        this.add(cameraControlPanel);
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TinyRequest closePacket = new TinyRequest(Tiny.CLOSE);
                try {
                    CameraControlPanel.this.client.send(closePacket);
                    CameraControlPanel.this.client.close();
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.add(quitButton);
        TinyRequest cameraPosRequest = new TinyRequest(Tiny.SEND_CAMERA_POSITION);
        this.client.send(cameraPosRequest);
        this.validate();
    }

    @Override
    public void packetReceived(InSimResponse response) {
        if (response instanceof CameraPositionResponse) {
            CameraPositionResponse cameraResponse = (CameraPositionResponse)response;
            this.camera = new SetDirectCameraRequest(cameraResponse);
            this.camera.setPosition(new InSimVector(0, 0, 0));
            this.camera.setFlags((short)8192);
            this.camera.setCameraType((byte)4);
            this.camera.setTime((short)500);
            this.headingSlider.setValue(this.camera.getHeading());
            this.headingSlider.setEnabled(true);
            this.pitchSlider.setValue(this.camera.getPitch() + 1);
            this.pitchSlider.setEnabled(true);
            this.rollSlider.setValue(this.camera.getRoll() + 1);
            this.rollSlider.setEnabled(true);
        }
    }
}

