/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.async;

import java.io.IOException;
import net.sf.jinsim.QueueClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.MessageRequest;
import net.sf.jinsim.request.ScreenModeRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;

public class Main
implements InSimListener {
    private QueueClient client;
    String hostname;
    int port;
    String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    public void run() {
        try {
            try {
                this.client = new QueueClient();
                this.client.addListener(this);
                this.client.connect(new TCPChannel(this.hostname, this.port), this.adminPassword, "async", (short)0, 0, this.port + 1);
                this.client.enableOutGauge(500);
                long startTime = System.currentTimeMillis();
                TinyRequest versionRequest = new TinyRequest(Tiny.VERSION);
                this.client.send(versionRequest);
                ScreenModeRequest modeRequest = new ScreenModeRequest();
                modeRequest.setHeight(0);
                modeRequest.setWidth(0);
                this.client.send(modeRequest);
                TinyRequest stateRequest = new TinyRequest(Tiny.SEND_STATE_INFO);
                this.client.send(stateRequest);
                MessageRequest helpRequest = new MessageRequest("/?");
                this.client.send(helpRequest);
                MessageRequest coloredMessageRequest = new MessageRequest("^1Red, ^7White and  ^4Blue");
                this.client.send(coloredMessageRequest);
                TinyRequest timeRequest = new TinyRequest(Tiny.GET_TIME_IN_HUNDREDS);
                this.client.send(timeRequest);
                System.out.println("Took: " + (System.currentTimeMillis() - startTime) + "ms");
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void packetReceived(InSimResponse response) {
        System.out.println(response.toString());
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.examples.console.Main <hostname> <port> <admin password>");
        }
    }
}

