/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.request.relay.InSimRelayRequest;

public class RelayClient
extends SimpleClient {
    private final String relayHostname = "isrelay.lfs.net";
    private final int relayPort = 47474;
    private TCPChannel channel;

    public void connect(String password) throws IOException {
        this.channel = new TCPChannel("isrelay.lfs.net", 47474);
        this.channel.setClient(this);
        Thread channelThread = new Thread(this.channel);
        channelThread.start();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void send(InSimRequest packet) throws IOException {
        this.checkPacket(packet);
        this.channel.send(packet);
    }

    private void checkPacket(InSimRequest packet) throws IOException {
        if (packet instanceof InSimRelayRequest) {
            return;
        }
        if (packet instanceof TinyRequest) {
            TinyRequest tinyRequest = (TinyRequest)packet;
            switch (tinyRequest.getSubtype()) {
                case NONE: 
                case VERSION: 
                case PING: 
                case VOTE_CANCEL: 
                case SEND_CAMERA_POSITION: 
                case SEND_STATE_INFO: 
                case GET_TIME_IN_HUNDREDS: 
                case MULTIPLAYER_INFO: 
                case ALL_CONNECTIONS: 
                case REORDER: 
                case RESTART: {
                    return;
                }
            }
        }
        switch (packet.getType()) {
            case SINGLE_CHARACTER: 
            case MESSAGE: 
            case MESSAGE_TO_CONNECTION: 
            case MESSAGE_EXTENDED: 
            case MESSAGE_TO_LOCAL: 
            case BUTTON_FUNCTION: 
            case BUTTON: {
                return;
            }
        }
        throw new IOException("Cannot send packet to relay case this type is not supported by the relay: " + packet);
    }
}

