/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import net.sf.jinsim.Channel;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.event.OutOfControlEvent;
import net.sf.jinsim.event.RaceEvent;
import net.sf.jinsim.event.TightRaceEvent;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MultiCarInfoResponse;
import net.sf.jinsim.types.CompCar;
import net.sf.jinsim.types.InSimVector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RaceEventClient
extends SimpleClient
implements InSimListener {
    private static Log log = LogFactory.getLog(RaceEventClient.class);

    @Override
    public void connect(Channel channel, String name, String password) throws IOException {
        this.addListener(this);
        super.connect(channel, name, password);
    }

    @Override
    public void connect(Channel channel, String password, String name, short flags, int interval, int udpPort) throws IOException {
        this.addListener(this);
        super.connect(channel, password, name, flags, interval, udpPort);
    }

    @Override
    public void packetReceived(InSimResponse response) {
        if (response instanceof MultiCarInfoResponse) {
            ArrayList<RaceEvent> events = new ArrayList<RaceEvent>();
            MultiCarInfoResponse mciResponse = (MultiCarInfoResponse)response;
            ArrayList<CompCar> carList = mciResponse.getCarInfoList();
            CompCar car1 = null;
            CompCar car2 = null;
            double closestDistance = Double.MAX_VALUE;
            ListIterator<CompCar> it = carList.listIterator();
            while (it.hasNext()) {
                CompCar currCar = it.next();
                if (car1 == null) {
                    car1 = currCar;
                }
                if (car1.getSpeed() > 10) {
                    float angDelta = Math.abs(car1.getDirectionInDegrees() - car1.getHeadingInDegrees());
                    if (angDelta > 180.0f) {
                        angDelta = 360.0f - angDelta + (float)Math.abs(car1.getDirection());
                    }
                    if (angDelta > 13.0f) {
                        events.add(new OutOfControlEvent(car1, angDelta));
                    }
                }
                InSimVector currPos = currCar.getPosition();
                Iterator jt = carList.listIterator(it.nextIndex());
                while (jt.hasNext()) {
                    InSimVector comparisonPos;
                    double currDist;
                    CompCar comparisonCar = (CompCar)jt.next();
                    if (currCar.getPlayerId() == comparisonCar.getPlayerId() || !((currDist = (comparisonPos = comparisonCar.getPosition()).delta(currPos)) < closestDistance)) continue;
                    closestDistance = currDist;
                    car1 = currCar;
                    car2 = comparisonCar;
                }
            }
            if (closestDistance < 655360.0) {
                events.add(new TightRaceEvent(car1, car2));
            }
            this.fireEvents(events);
        }
    }

    protected abstract void fireTightRaceEvent(TightRaceEvent var1);

    protected abstract void fireOutOfControlEvent(OutOfControlEvent var1);

    private void fireEvents(ArrayList<RaceEvent> events) {
        for (RaceEvent currEvent : events) {
            if (currEvent instanceof TightRaceEvent) {
                this.fireTightRaceEvent((TightRaceEvent)currEvent);
                continue;
            }
            if (!(currEvent instanceof OutOfControlEvent)) continue;
            this.fireOutOfControlEvent((OutOfControlEvent)currEvent);
        }
    }
}

