/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jinsim.Client;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueClient
extends Client {
    private static Log log = LogFactory.getLog(QueueClient.class);
    private static final int QUEUE_SIZE = 253;
    private ArrayList<InSimListener> listeners = new ArrayList(253);

    public void setListeners(List<InSimListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void addListener(InSimListener listener) {
        int i = 0;
        while (this.listeners.size() > i && this.listeners.get(i) != null) {
            ++i;
        }
        if (i > 253) {
            throw new IndexOutOfBoundsException("Maximum number of listeners exceeded");
        }
        System.out.println("adding at index " + i);
        this.listeners.add(i, listener);
    }

    public void removeListener(InSimListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners(InSimResponse packetData) {
        int requestInfo = packetData.getRequestInfo() & 0xFF;
        InSimListener listener = null;
        if (requestInfo > 0 && requestInfo < 253 && requestInfo <= this.listeners.size()) {
            listener = this.listeners.get(requestInfo - 1);
        }
        if (listener != null) {
            listener.packetReceived(packetData);
        } else {
            for (InSimListener l : this.listeners) {
                l.packetReceived(packetData);
            }
        }
    }

    @Override
    public void send(InSimRequest packet) throws IOException {
        super.send(packet);
    }

    public void send(InSimRequest packet, InSimListener listener) throws IOException {
        int index = this.listeners.indexOf(listener);
        if (index > -1) {
            System.out.println("set request info: " + (index + 1));
            packet.setRequestInfo((byte)(index + 1));
        } else {
            packet.setRequestInfo((byte)-1);
        }
        super.send(packet);
    }
}

