#include <iostream>
#include <vector>
#include "area.h"

#include "cinsim/cinsim.h"	//Headers for CInsim library
#include <iostream>
#include <string>
#include <sstream>
#include <stdlib.h>


CInsim insim;			//CInsim object, handles the communication with LFS
struct IS_BTN pack_btn;
Area backstraight;
Area chicane;
Area sector2;
std::string s_back = "Backstraight";
std::string s_chic = "Chicane";
std::string s_sect2 = "Sector 2";
std::string s_none = "";

int main()
{
  backstraight.add_vertex(Point(140, 396));
  backstraight.add_vertex(Point(164, 403));
  backstraight.add_vertex(Point(435, -722));
  backstraight.add_vertex(Point(405, -419));
  
  chicane.add_vertex(Point(124, 541));
  chicane.add_vertex(Point(72, 628));
  chicane.add_vertex(Point(17, 592));
  chicane.add_vertex(Point(12, 508));
  chicane.add_vertex(Point(40, 508));
  
  sector2.add_vertex(Point(203, -767));
  sector2.add_vertex(Point(134, -724));
  sector2.add_vertex(Point(143, -623));
  sector2.add_vertex(Point(159, -604));
  sector2.add_vertex(Point(183, -663));
  
  pack_btn.Size = sizeof(struct IS_BTN);
  pack_btn.Type = ISP_BTN;
  pack_btn.ReqI = 1;
  pack_btn.UCID = 0;
  pack_btn.ClickID = 237;
  pack_btn.BStyle = ISB_DARK;
  pack_btn.L = 1;
  pack_btn.T = 70;
  pack_btn.W = 60;
  pack_btn.H = 10;

  int retVal = 0;
  struct IS_VER verPack;	//LFS can tell us info about it's version and InSim version, store that info in this struct.

  //Try to connect to LFS
  retVal = insim.init("127.0.0.1",	//LFS will run on local machine
		      (word)29999,	//InSim will accept connection on port 29999
		      "Sample InSim app",	//Short name for our app, will appear in LFS
		      "",		//No admin password
		      &verPack,		//Pointer to IS_VERSION packet
		      '!',		//InSim command character
		      ISF_MCI,		//We're writing a local InSim app
		      1000,		//Receive updates every 1000 msecs
		      0);		//No UDP today
  
  //Could we connect to LFS?
  if(retVal < 0) //We could not
  {
    //Tell the user and exit
    std::cerr << "Error connecting to LFS!" << std::endl;
    return -1;
  }
  
  //All OK, report version of LFS and InSim
  std::cout << "Connected to LFS " << verPack.Version << ", InSim ver. " << verPack.InSimVer << std::endl;
 
  //Now enter the main loop which will receive packets from LFS
  int recvErr = 0;
  int packetType = 0;
  bool canRun = true;	//Run the loop as long as this is true
 
  while(canRun)
  {
    //Get the next packet in the buffer
    recvErr = insim.next_packet();
    if(recvErr < 0)	//Something went wrong
    {
      //Tell the user and exit
      //std::cerr << "Error receiving packets from LFS!" << std::endl;
      return -1;
    }
    
    //We have a packet, check it's type
    packetType = insim.peek_packet();
    
    //Handle each type of packet
    switch(packetType)
    {
      case ISP_MCI:	//A button was clicked in LFS
	  struct IS_MCI* mci = (struct IS_MCI*)insim.get_packet();
	  /* Convers coordinates to meters */
	  int redX = mci->Info[0].X / 65536;
	  int redY = mci->Info[0].Y / 65536;
	  Point pos(redX, redY);
	  
	  if (backstraight.contains(pos))
	    strcpy(pack_btn.Text, s_back.c_str());
	  else if (chicane.contains(pos))
	    strcpy(pack_btn.Text, s_chic.c_str());
	  else if (sector2.contains(pos))
	    strcpy(pack_btn.Text, s_sect2.c_str());
	  else
	    strcpy(pack_btn.Text, s_none.c_str());
	  
	  insim.send_packet(&pack_btn);
	break;		//Remember to have this after EVERY case: statement!!!
    }
  }
  
  std::cerr << "Exiting" << std::endl;
  
  //Successful exit
  insim.isclose();	//I forgot to add this line in the video, but connection to InSim should be always properly closed
  return 0;
}