import pyinsim


class ScreenManager(object):
    def __init__(self, insim, ncn):
        self.insim = insim
        self.ncn = ncn        
        self.current_screen = None
        
    def transition(self, screen):
        if self.current_screen:
            self.current_screen.unload_buttons()
        self.current_screen = screen
        self.current_screen.screen_manager = self
        self.current_screen.insim = self.insim
        self.current_screen.ncn = self.ncn
        self.current_screen.load_buttons()
        
    def button_click(self, btc):
        self.current_screen.button_click(btc)   
        
        
class Screen(object):
    def __init__(self):
        self.screen_manager = None
        self.insim = None
        self.ncn = None
        
    def load_buttons(self):
        pass
    
    def unload_buttons(self):
        pass
    
    def button_click(self, btc):
        pass
    
    
class WelcomeScreen(Screen):
    def __init__(self):
        Screen.__init__(self)
        
    def load_buttons(self):
        self.insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=self.ncn.UCID, ClickID=1, 
                        BStyle=pyinsim.ISB_DARK, L=20, T=20, W=40, H=10, Text='Welcome Screen')        
        self.insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=self.ncn.UCID, ClickID=2, 
                        BStyle=pyinsim.ISB_LIGHT|pyinsim.ISB_CLICK, L=20, T=32, W=40, H=10, Text='Go to options screen')
    
    def unload_buttons(self):
        self.insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_DEL_BTN, UCID=self.ncn.UCID, ClickID=1)
        self.insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_DEL_BTN, UCID=self.ncn.UCID, ClickID=2)        
                
    def button_click(self, btc):
        if btc.ClickID == 2:
            self.screen_manager.transition(OptionsScreen())
    
    
class OptionsScreen(Screen):
    def __init__(self):
        Screen.__init__(self)
        
    def load_buttons(self):
        self.insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=self.ncn.UCID, ClickID=1, 
                        BStyle=pyinsim.ISB_DARK, L=20, T=20, W=40, H=10,Text='Options Screen')        
        self.insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=self.ncn.UCID, ClickID=2, 
                        BStyle=pyinsim.ISB_LIGHT|pyinsim.ISB_CLICK, L=20, T=32, W=40, H=10,Text='Go to welcome')
    
    def unload_buttons(self):
        self.insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_DEL_BTN, UCID=self.ncn.UCID, ClickID=1)
        self.insim.send(pyinsim.ISP_BFN, SubT=pyinsim.BFN_DEL_BTN, UCID=self.ncn.UCID, ClickID=2)        
                
    def button_click(self, btc):
        if btc.ClickID == 2:
            self.screen_manager.transition(WelcomeScreen())             
    
    
class InSimApp(object):
    def __init__(self):
        self.screen_managers = {}
        self.insim = pyinsim.insim('127.0.0.2', 29999, Admin='', IName='InSimFSM')
        self.insim.bind(pyinsim.ISP_ISM, self.insim_multi)        
        self.insim.bind(pyinsim.ISP_NCN, self.new_connection)
        self.insim.bind(pyinsim.ISP_CNL, self.connection_leave)
        self.insim.bind(pyinsim.ISP_BTC, self.button_click)
        self.insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_ISM)
    
    def insim_multi(self, insim, ism):
        insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NCN)
        
    def new_connection(self, insim, ncn):
        screen_manager = ScreenManager(insim, ncn)
        self.screen_managers[ncn.UCID] = screen_manager
        screen_manager.transition(WelcomeScreen())
    
    def connection_leave(self, insim, cnl):
        del self.screen_managers[cnl.UCID]
        
    def button_click(self, insim, btc):
        self.screen_managers[btc.UCID].button_click(btc)
    

if __name__ == '__main__':
    InSimApp()
    
    pyinsim.run()
    