﻿using System;
using System.Threading;
using InSimDotNet;
using InSimDotNet.Packets;

namespace VectorMath {
    class Program {
        int plrPosX;
        int plrPosY;
        Vector2D motVect;

        void Run() {
            try {
                // Create new InSim connection and dispose it once we're finished.
                using (InSim insim = new InSim()) {
                    insim.Bind<IS_MCI>(MultiCarInfo); // Bind handler for MCI packet event.

                    // Initialize InSim.
                    insim.Initialize(new InSimSettings {
                        Host = "127.0.0.1",
                        Port = 29999,
                        Flags = InSimFlags.ISF_MCI, // Enable MCI updates.
                        Interval = 1000, // Send updates every second.
                        IName = "VectorMath",
                        Admin = String.Empty, // Admin password here.
                    });

                    // Stop program from exiting while LFS is connected.
                    while (insim.IsConnected) {
                        Thread.Sleep(200);
                    }
                }
            }
            catch (Exception ex) {
                Console.WriteLine("InSim Initialize Failed: {0}", ex.Message);
            }
        }

        void MultiCarInfo(InSim insim, IS_MCI mci) {
            for (int i = 0; i < mci.NumC; i++) {
                /* Get player's heading */
                int heading = mci.Info[i].Heading;
                /* Convert heading to degrees */
                float angle_deg = (heading * 180.0f / 32768.0f);
                if (i == 0) {
                    /* Create a motion vector from player's car heading.
                     * LFS reports heading of 0 degrees when the car is moving in direction of the Y axis.
                     * Cartesian system considers this 90 degrees, so add 90 to the player's heading. */
                    Vector2D vec = new Vector2D(Vector2D.DegToRad(angle_deg + 90.0f));
                    /* Store player's position */
                    plrPosX = mci.Info[i].X;
                    plrPosY = mci.Info[i].Y;
                    motVect = vec;
                }
                else {
                    /* Create position vector by subtracting "target" car's position from player's car position */
                    Vector2D vec = new Vector2D(mci.Info[i].X - plrPosX, mci.Info[i].Y - plrPosY);
                    string text = "Angle: " + Vector2D.RadToDeg(Vector2D.GetAngle(vec, motVect)) + " Distance: " + vec.Magnitude / 65536;

                    insim.Send(new IS_BTN {
                        ReqI = 1,
                        UCID = 1,
                        ClickID = 237,
                        BStyle = ButtonStyles.ISB_DARK,
                        L = 1,
                        T = 70,
                        W = 60,
                        H = 10,
                        Text = text,
                    });
                }
            }
        }

        static void Main(string[] args) {
            new Program().Run();
        }
    }
}
