#include "vector_math.hpp"

/** Normalizes a vector passed by reference.
 *  A normalized vector has a magnitude of 1. */
void vector_math::normalize_vector(Vector2D& vec)
{
  if (vec.x == 0) {
    vec.y = 1;
    return;
  }
  if (vec.y == 0) {
    vec.x = 1;
    return;
  }

  float tan_alpha = vec.y / vec.x;
  /* Calculate normalized size of X component */
  float vx_norm = 1 / sqrt(pow(tan_alpha, 2) + 1);
  /* Calculate normalized size of Y component */
  float vy_norm = tan_alpha * vx_norm;

  /* Make sure the normalized vector has the same direction as the original one */
  if (!same_sign(vec.x, vx_norm))
    vx_norm *= -1;
  if (!same_sign(vec.y, vy_norm))
    vy_norm *= -1;

  vec.x = vx_norm;
  vec.y = vy_norm;
}
  
/** Returns an angle between two normalized vectors.
 */
float vector_math::get_angle_norm(Vector2D const& vec1, Vector2D const& vec2)
{
  float scalar_mul = (vec1.x * vec2.x) + (vec1.y * vec2.y);
  return acos(scalar_mul);
}

/** Returns an angle between two vectors.
 *  Local copies of the passed vectors are used. */
float vector_math::get_angle(Vector2D vec1, Vector2D vec2)
{
  normalize_vector(vec1);
  normalize_vector(vec2);
  return get_angle_norm(vec1, vec2);
}