#include "vector2d.hpp"
#include <cmath>

#include <iostream>

/** Default constructor */
Vector2D::Vector2D()
{
  this->x = 0;
  this->y = 0;
}

/** Constructs a Vector2D,
 *  parameters are X and Y components. */
Vector2D::Vector2D(float x, float y)
{
  this->x = x;
  this->y = y;
}

/** Constructs a Vector2D,
 *  parameter is an angle between the vector and the X axis.
 *  Angle parameter is expected to be in radians. */
Vector2D::Vector2D(float angle)
{
  /* Vector has only Y component */
  if (angle == HALF_PI) {
    this->x = 0;
    this->y = 1;
  } else if (angle == THREEHALVES_PI) {
    this->x = 0;
    this->y = -1;
  }
  
  if (angle < HALF_PI || angle > THREEHALVES_PI)
    this->x = 1;
  else
    this->x = -1;
  
  this->y = tan(angle) * this->x;
}

/* NOTE: To avoid an embarrasing pitfall, note that both Vector2D(2,5) and Vector2D(2.5)
 * are valid constructor calls, but yield completely different vectors! */

float Vector2D::angle()
{
  return atan(this->y / this->x);
}

/** Returns magnitude ("length") of the vector */
float Vector2D::magnitude()
{
  return sqrt(x*x + y*y);
}