#ifndef  WRITETOJOYSTICKDRIVER_H_
#define WRITETOJOYSTICKDRIVER_H_

#define VID_LOGITECH 0x046d

#include <libusb-1.0/libusb.h>

typedef struct {
	// reserve space for max. 4 command strings, 8 chars each
	unsigned char cmds[4][8];
	// how many command strings are actually used
	unsigned int numCmds;
} cmdstruct;

typedef struct {
	char shortname[255];
	char name[255];
	unsigned int restricted_pid;
	unsigned int native_pid;
	unsigned int min_rotation;
	unsigned int max_rotation;
	unsigned int revision;               /* aka bcdDevice - Device Release Number according to HID specs */
	int (*get_nativemode_cmd)(cmdstruct *c);
	int (*get_range_cmd)(cmdstruct *c, int range);
	int (*get_autocenter_cmd)(cmdstruct *c, int centerforce, int rampspeed);
}wheelstruct;

int get_nativemode_cmd_DFP(cmdstruct *c);
int get_nativemode_cmd_DFGT(cmdstruct *c);
int get_nativemode_cmd_G25(cmdstruct *c);
int get_nativemode_cmd_G27(cmdstruct *c);
int get_range_cmd(cmdstruct *c, int range);
int get_range_cmd2(cmdstruct *c, int range);
int get_autocenter_cmd(cmdstruct *c, int centerforce, int rampspeed);

static wheelstruct wheels[] = {
	{
		"DFGT",
		"Driving Force GT",
		0xc294,
		0xc29A,
		40,
		900,
		0,
		&get_nativemode_cmd_DFGT,
		&get_range_cmd,
		&get_autocenter_cmd
	}
};

int set_autocenter(wheelstruct* w, int centerforce, int rampspeed);
int set_range(wheelstruct* w, unsigned short int range);
unsigned short int clamprange(wheelstruct* w, unsigned short int range);
void list_devices();
int send_command(libusb_device_handle *handle, cmdstruct command );
int set_native_mode(wheelstruct* w);
int alt_set_autocenter(int centerforce, char *device_file_name, int wait_for_udev);
int set_gain(int gain, char *device_file_name, int wait_for_udev);
int reset_wheel(wheelstruct* w);

#endif
