using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

namespace ADMLapperGUI
{


    public partial class MainForm : Form
    {
        XmlDocument myDoc = new XmlDocument();

        public MainForm()
        {
            InitializeComponent();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            ManageServers mng = new ManageServers( this );
            mng.ShowDialog();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {

            updateTree();
        }
        public void updateTree()
        {
            treeViewMain.TreeViewNodeSorter = null;
            treeViewMain.Nodes.Clear();
            myDoc.Load("ADMLapperGUI.cfg");
            TreeNode tn = new TreeNode("Toto");
            tn.ImageIndex = 0;
            tn.SelectedImageIndex = 0;
            treeViewMain.Nodes.Add(tn);
            processNode(myDoc.SelectNodes("/ADMLapperGUI/LAPServers"), tn);
            treeViewMain.Sort();
            tn.Expand();
            treeViewMain.TreeViewNodeSorter = new NodeSorter();
        }
        private void processNode(XmlNodeList nodeList, TreeNode tnode)
        {
            foreach (XmlNode node in nodeList)
            {
                if (node.NodeType == XmlNodeType.Element)
                {
                    if (node.Name == "infoServ")
                    {
                        TreeNode newNode = tnode.Nodes.Add( node.Attributes["name"].Value );
                        newNode.ImageIndex = 2;
                        newNode.SelectedImageIndex = 2;
                        newNode.Tag = node;
                    }
                    else if (node.Name == "LAPServers")
                    {
                        tnode.Tag = node;
                        tnode.Text = node.Attributes["name"].Value;
                        if (node.HasChildNodes)
                            processNode(node.ChildNodes, tnode);
                    }
                    else if (node.Name == "GroupServers")
                    {
                        TreeNode newNode = tnode.Nodes.Add(node.Attributes["name"].Value);
                        newNode.ImageIndex = 0;
                        newNode.SelectedImageIndex = 0;
                        newNode.Tag = node;

                        if (node.HasChildNodes)
                            processNode(node.ChildNodes, newNode);
                    }
                }

            }
        }

        private void treeViewMain_AfterSelect(object sender, TreeViewEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            majInfoNode(currXmlNode);
        }
        private void majInfoNode(XmlNode currXmlNode)
        {
            if (currXmlNode.Name == "infoServ" )
            {
                serverIp.Text = currXmlNode.Attributes["ip"].Value;
                serverPass.Text = currXmlNode.Attributes["pass"].Value;
            }
            else
            {
                serverIp.Text = "";
                serverPass.Text = "";
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            updateTree();
        }

        private void treeViewMain_AfterCollapse(object sender, TreeViewEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            if (currXmlNode.Name == "GroupServers" || currXmlNode.Name == "LAPServers")
            {
                e.Node.ImageIndex = 0;
                e.Node.SelectedImageIndex = 0;
            }

        }

        private void treeViewMain_AfterExpand(object sender, TreeViewEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            if (currXmlNode.Name == "GroupServers" || currXmlNode.Name == "LAPServers")
            {
                e.Node.ImageIndex = 1;
                e.Node.SelectedImageIndex = 1;
            }

        }

    }
    public class NodeSorter : IComparer
    {
        // Compare the length of the strings, or the strings
        // themselves, if they are the same length.
        public int Compare(object x, object y)
        {
            TreeNode Tx = (TreeNode)x;
            TreeNode Ty = (TreeNode)y;
            XmlNode xmlX = (XmlNode)Tx.Tag;
            XmlNode xmlY = (XmlNode)Ty.Tag;
            if (string.Compare(xmlX.Name, xmlY.Name) == 0)
            {
                return( string.Compare( xmlX.Attributes["name"].Value,xmlY.Attributes["name"].Value ) );
            }
            else
                return (string.Compare(xmlX.Name, xmlY.Name));
        }
    }

}