﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ForceFeedbackExample
{
    /// <summary>
    /// Example Form that uses Managed DirectInput for force feedback
    /// 
    /// By Christopher M. Park -- http://www.christophermpark.com
    /// </summary>
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            DirectInputWrapper.Initialize( this );
        }

        private void btnSendBriefJolt_Click( object sender, EventArgs e )
        {
            this.SendForce( DirectInputWrapper.ForceType.BriefJolt );
        }

        private void btnSendVeryBriefJolt_Click( object sender, EventArgs e )
        {
            this.SendForce( DirectInputWrapper.ForceType.VeryBriefJolt );
        }

        private void btnSendLowRumble_Click( object sender, EventArgs e )
        {
            this.SendForce( DirectInputWrapper.ForceType.LowRumble );
        }

        private void btnSendHardRumble_Click( object sender, EventArgs e )
        {
            this.SendForce( DirectInputWrapper.ForceType.HardRumble );
        }

        private void SendForce( DirectInputWrapper.ForceType Type )
        {
            if ( this.chkPlayer1.Checked )
                DirectInputWrapper.SendForce( Type, true );
            if ( this.chkPlayer2.Checked )
                DirectInputWrapper.SendForce( Type, false );
        }
    }
}
