﻿using System.Windows.Forms;
using LfsPoints.Projects;

namespace LfsPoints {
    public class StandingsColumnSorter : IColumnSorter {
        public int Column { get; set; }
        public SortOrder Order { get; set; }

        public StandingsColumnSorter() {
            Reset();
        }

        public void Reset() {
            Column = 0;
            Order = SortOrder.Ascending;
        }

        public int Compare(object x, object y) {
            Standing a = (Standing)((ListViewItem)x).Tag;
            Standing b = (Standing)((ListViewItem)y).Tag;
            int compare = 0;

            switch (Column) {
                case 0:
                case 2:
                    compare = a.Position.CompareTo(b.Position);
                    break;
                case 1:
                    compare = a.DisplayName.CompareTo(b.DisplayName);
                    break;
            }

            if (Order == SortOrder.Ascending) {
                return compare;
            }
            else if (Order == SortOrder.Descending) {
                return -compare;
            }
            return 0;
        }
    }
}
