﻿using System.Windows.Forms;
using LfsPoints.Projects;
using System;

namespace LfsPoints {
    public class ResultsColumnSorter : IColumnSorter {
        public int Column { get; set; }
        public SortOrder Order { get; set; }

        public ResultsColumnSorter() {
            Reset();
        }

        public void Reset() {
            Column = 0;
            Order = SortOrder.Ascending;
        }

        public int Compare(object x, object y) {
            Result a = (Result)((ListViewItem)x).Tag;
            Result b = (Result)((ListViewItem)y).Tag;
            int compare = 0;

            switch (Column) {
                case 0:
                case 4:
                case 7:
                    compare = a.Position.CompareTo(b.Position);
                    break;
                case 1:
                    compare = a.DisplayName.CompareTo(b.DisplayName);
                    break;
                case 2:
                    compare = a.CarName.CompareTo(b.CarName);
                    break;
                case 3:
                    compare = (a.StartPosition > 0 ? a.StartPosition : Int32.MaxValue).CompareTo(b.StartPosition > 0 ? b.StartPosition : Int32.MaxValue);
                    break;
                case 5:
                    compare = a.PenaltyTime.Value.CompareTo(b.PenaltyTime.Value);
                    break;
                case 6:
                    compare = a.BestLapTime.Value.CompareTo(b.BestLapTime.Value);
                    break;
            }

            if (Order == SortOrder.Ascending) {
                return compare;
            }
            else if (Order == SortOrder.Descending) {
                return -compare;
            }
            return 0;
        }
    }
}
