﻿using System;
using System.Windows.Forms;

namespace LfsPoints {
    public partial class PromptDialog : Form {
        private string _originalValue;

        public string Title {
            get { return Text; }
            set { Text = value; }
        }

        public string Caption {
            get { return _captionLabel.Text; }
            set { _captionLabel.Text = value; }
        }

        public string Value {
            get { return _valueTextBox.Text; }
            set {
                _valueTextBox.Text = value;
                _originalValue = value;
            }
        }

        public PromptDialog() {
            InitializeComponent();

            ActiveControl = _valueTextBox;
        }

        private void OnOkButtonClick(object sender, EventArgs e) {
            if (!String.IsNullOrWhiteSpace(Value) && Value != _originalValue) {
                DialogResult = DialogResult.OK;
            }
            Close();
        }
    }
}
