﻿using System.Xml;
using System.Xml.Serialization;

namespace LfsPoints.Projects {
    public static class SerializationHelper {
        public static void Serialize<T>(string fileName, T value) {
            using (XmlWriter writer = XmlWriter.Create(fileName)) {
                new XmlSerializer(typeof(T)).Serialize(writer, value);
            }
        }

        public static T Deserialize<T>(string fileName) {
            using (XmlReader reader = XmlReader.Create(fileName)) {
                return (T)new XmlSerializer(typeof(T)).Deserialize(reader);
            }
        }
    }
}
