﻿using System;
using System.Collections.Generic;
using System.Text;

namespace LfsPoints.Projects {
    public static class EncodingHelper {
        private static readonly Dictionary<char, Encoding> EncodingMap = new Dictionary<char, Encoding> 
        {
            { 'L', Encoding.GetEncoding(1252) },
            { 'G', Encoding.GetEncoding(1253) },
            { 'C', Encoding.GetEncoding(1251) },
            { 'J', Encoding.GetEncoding(932) },
            { 'E', Encoding.GetEncoding(1250) },
            { 'T', Encoding.GetEncoding(1254) },
            { 'B', Encoding.GetEncoding(1257) },
            { 'H', Encoding.GetEncoding(950) },
            { 'S', Encoding.GetEncoding(936) },
            { 'K', Encoding.GetEncoding(949) },
        };

        private static readonly Dictionary<char, char> EscapeMap = new Dictionary<char, char>
        {
            { 'v', '|' },
            { 'a', '*' },
            { 'c', ':' },
            { 'd', '\\' },
            { 's', '/' },
            { 'q', '?' },
            { 't', '"' },
            { 'l', '<' },
            { 'r', '>' },
            { '^', '^' },
        };

        public static string GetString(byte[] buffer) {
            StringBuilder output = new StringBuilder(buffer.Length);
            Encoding encoding = EncodingMap['L'], enc = null;
            int i = 0, start = 0;
            char escape;

            for (i = 0; i < buffer.Length; i++) {
                char current = (char)buffer[i];

                if (current == Char.MinValue) {
                    break;
                }
                else if (current == '^') {
                    if (i - start > 0) {
                        output.Append(encoding.GetString(buffer, start, i - start));
                    }
                    start = (++i) + 1;

                    char next = (char)buffer[i];
                    if (EncodingMap.TryGetValue(next, out enc)) {
                        encoding = enc;
                    }
                    else if (EscapeMap.TryGetValue(next, out escape)) {
                        output.Append(escape);
                    }
                    else {
                        output.Append('^');
                        output.Append(next);
                    }
                }
            }

            if (i - start > 0) {
                output.Append(encoding.GetString(buffer, start, i - start));
            }

            return output.ToString();
        }
    }
}
