﻿using System;
using System.Windows.Forms;
using LfsPoints.Commands;
using LfsPoints.Projects;

namespace LfsPoints.Menus {
    public class ReplaysMenu : MenuBase {
        private ToolStripMenuItem _removeMenuItem;
        private ToolStripMenuItem _addReplaysMenuItem;
        private ToolStripSeparator _toolStripSeparator;

        public ReplaysMenu()
            : base() {
            InitializeComponent();

            _removeMenuItem.Click += new EventHandler(_removeMenuItem_Click);
        }

        private void InitializeComponent() {
            this._removeMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._toolStripSeparator = new System.Windows.Forms.ToolStripSeparator();
            this._addReplaysMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            // 
            // _removeMenuItem
            // 
            this._removeMenuItem.Name = "_removeMenuItem";
            this._removeMenuItem.ShortcutKeyDisplayString = "Del";
            this._removeMenuItem.Size = new System.Drawing.Size(146, 22);
            this._removeMenuItem.Text = "Remove";
            // 
            // _toolStripSeparator
            // 
            this._toolStripSeparator.Name = "_toolStripSeparator";
            this._toolStripSeparator.Size = new System.Drawing.Size(143, 6);
            // 
            // _addReplaysMenuItem
            // 
            this._addReplaysMenuItem.Name = "_addReplaysMenuItem";
            this._addReplaysMenuItem.Size = new System.Drawing.Size(146, 22);
            this._addReplaysMenuItem.Text = "Add Replays";
            // 
            // ReplaysMenu
            // 
            this.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._addReplaysMenuItem,
            this._toolStripSeparator,
            this._removeMenuItem});
            this.Text = "&Replays";
        }

        protected override void OnDropDownOpening(EventArgs e) {
            ClearAddReplaysMenu();

            foreach (Allocation allocation in Project.Current.Allocations) {
                ToolStripItem item = _addReplaysMenuItem.DropDownItems.Add(allocation.Name);
                item.Click += new EventHandler(_allocationMenuItem_Click);
                item.Tag = allocation;
            }

            base.OnDropDownOpening(e);
        }

        private void ClearAddReplaysMenu() {
            foreach (ToolStripItem item in _addReplaysMenuItem.DropDownItems) {
                item.Click -= _allocationMenuItem_Click;
            }
            _addReplaysMenuItem.DropDownItems.Clear();
        }

        private void _allocationMenuItem_Click(object sender, EventArgs e) {
            Allocation allocation = (Allocation)((ToolStripItem)sender).Tag;
            AppWorkbench.ExecuteCommand(new AddReplaysCommand(allocation));
        }

        private void _removeMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new RemoveReplaysCommand());
        }
    }
}
