﻿using System;
using System.Collections.Specialized;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using LfsPoints.Properties;

namespace LfsPoints.Menus {
    public class RecentProjectsMenuItem : MenuBase {
        public RecentProjectsMenuItem()
            : base() {
            DropDownItems.Add(String.Empty); // Placeholder to make popout arrow appear
        }

        protected override void OnDropDownOpening(EventArgs e) {
            StringCollection recentProjects = Settings.Default.RecentProjects;

            ClearRecentProjectsMenu();

            for (int i = 0, num = 1; i < recentProjects.Count; i++, num++) {
                string fileName = String.Format("{0}. {1}", num, TruncateFileName(recentProjects[i]));
                ToolStripItem item = DropDownItems.Add(fileName);
                item.Click += new EventHandler(_openRecentMenuItem_Click);
                item.Tag = recentProjects[i];
            }

            base.OnDropDownOpening(e);
        }

        private void ClearRecentProjectsMenu() {
            foreach (ToolStripItem item in DropDownItems) {
                item.Click -= _openRecentMenuItem_Click;
            }
            DropDownItems.Clear();
        }

        protected override void OnMouseLeave(EventArgs e) {
            if (DropDownItems.Count == 0) {
                DropDownItems.Add(String.Empty);
            }

            base.OnMouseLeave(e);
        }

        private static string TruncateFileName(string fileName) {
            const int TruncateLength = 6;

            string[] tokens = fileName.Split(Path.DirectorySeparatorChar);

            if (tokens.Length - 1 > TruncateLength) {
                fileName = String.Join(Path.DirectorySeparatorChar.ToString(), tokens.Skip(tokens.Length - TruncateLength));

                return String.Format("{0}{1}...{1}{2}", tokens[0], Path.DirectorySeparatorChar, fileName);
            }

            return fileName;
        }

        private void _openRecentMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.OpenRecentProject((string)((ToolStripItem)sender).Tag);
        }
    }
}
