﻿using System;
using System.Windows.Forms;

namespace LfsPoints.Menus {
    public class MenuBase : ToolStripMenuItem {
        protected static IWorkbench AppWorkbench {
            get { return (IWorkbench)Application.OpenForms[0]; }
        }

        public MenuBase()
            : base() {

            // For some reason ToolStripMenuItem does not provide an override for
            // DropDownOpening, so we make our own.
            DropDownOpening += new EventHandler(MenuBase_DropDownOpening);
        }

        private void MenuBase_DropDownOpening(object sender, EventArgs e) {
            OnDropDownOpening(e);
        }

        protected virtual void OnDropDownOpening(EventArgs e) { }
    }
}
