﻿using System;
using System.Linq;
using System.Windows.Forms;
using LfsPoints.Commands;
using LfsPoints.Projects;

namespace LfsPoints.Menus {
    public class FileMenu : MenuBase {
        private ToolStripMenuItem _newMenuItem;
        private ToolStripMenuItem _openMenuItem;
        private ToolStripMenuItem _saveMenuItem;
        private ToolStripMenuItem _saveAsMenuItem;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripSeparator toolStripSeparator2;
        private RecentProjectsMenuItem _openRecentMenuItem;
        private ToolStripMenuItem _exportMenuItem;
        private ToolStripSeparator toolStripSeparator3;
        private ToolStripMenuItem _exitToolStripMenuItem;

        public FileMenu()
            : base() {
            InitializeComponent();

            _newMenuItem.Click += new EventHandler(_newMenuItem_Click);
            _openMenuItem.Click += new EventHandler(_openMenuItem_Click);
            _saveMenuItem.Click += new EventHandler(_saveMenuItem_Click);
            _saveAsMenuItem.Click += new EventHandler(_saveAsMenuItem_Click);
            _exportMenuItem.Click += new EventHandler(_exportMenuItem_Click);
            _exitToolStripMenuItem.Click += new EventHandler(_exitMenuItem_Click);
        }

        private void InitializeComponent() {
            this._newMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._openMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._saveMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._saveAsMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this._openRecentMenuItem = new LfsPoints.Menus.RecentProjectsMenuItem();
            this._exportMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            // 
            // _newMenuItem
            // 
            this._newMenuItem.Name = "_newMenuItem";
            this._newMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.N)));
            this._newMenuItem.Size = new System.Drawing.Size(197, 22);
            this._newMenuItem.Text = "New";
            // 
            // _openMenuItem
            // 
            this._openMenuItem.Name = "_openMenuItem";
            this._openMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.O)));
            this._openMenuItem.Size = new System.Drawing.Size(197, 22);
            this._openMenuItem.Text = "Open";
            // 
            // _saveMenuItem
            // 
            this._saveMenuItem.Name = "_saveMenuItem";
            this._saveMenuItem.ShortcutKeyDisplayString = "";
            this._saveMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.S)));
            this._saveMenuItem.Size = new System.Drawing.Size(197, 22);
            this._saveMenuItem.Text = "Save";
            // 
            // _saveAsMenuItem
            // 
            this._saveAsMenuItem.Name = "_saveAsMenuItem";
            this._saveAsMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Shift) 
            | System.Windows.Forms.Keys.S)));
            this._saveAsMenuItem.Size = new System.Drawing.Size(197, 22);
            this._saveAsMenuItem.Text = "Save As...";
            // 
            // _exitToolStripMenuItem
            // 
            this._exitToolStripMenuItem.Name = "_exitToolStripMenuItem";
            this._exitToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.F4)));
            this._exitToolStripMenuItem.Size = new System.Drawing.Size(197, 22);
            this._exitToolStripMenuItem.Text = "Exit";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(194, 6);
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(194, 6);
            // 
            // _openRecentMenuItem
            // 
            this._openRecentMenuItem.Name = "_openRecentMenuItem";
            this._openRecentMenuItem.Size = new System.Drawing.Size(197, 22);
            this._openRecentMenuItem.Text = "Open Recent";
            // 
            // _exportMenuItem
            // 
            this._exportMenuItem.Name = "_exportMenuItem";
            this._exportMenuItem.Size = new System.Drawing.Size(197, 22);
            this._exportMenuItem.Text = "Export";
            // 
            // toolStripSeparator3
            // 
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            this.toolStripSeparator3.Size = new System.Drawing.Size(194, 6);
            // 
            // FileMenu
            // 
            this.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._newMenuItem,
            this._openMenuItem,
            this._openRecentMenuItem,
            this.toolStripSeparator1,
            this._saveMenuItem,
            this._saveAsMenuItem,
            this.toolStripSeparator3,
            this._exportMenuItem,
            this.toolStripSeparator2,
            this._exitToolStripMenuItem});
            this.Text = "&File";

        }

        protected override void OnDropDownOpening(EventArgs e) {
            _exportMenuItem.Enabled = Project.Current.Replays.Any();

            base.OnDropDownOpening(e);
        }

        private void _newMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.NewProject();
        }

        private void _openMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.OpenProject();
        }

        private void _saveMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.SaveProject();
        }

        private void _saveAsMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.SaveProjectAs();
        }

        private void _exportMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new ExportProjectCommand());
        }

        private void _exitMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.Close();
        }
    }
}
