﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using LfsPoints.Commands;
using LfsPoints.Projects;

namespace LfsPoints.Menus {
    public class DisplayNamesMenuItem : MenuBase {
        private ToolStripSeparator _toolStripSeparator;
        private ToolStripMenuItem _customizeMenuItem;

        public DisplayNamesMenuItem()
            : base() {
            InitializeComponent();

            _customizeMenuItem.Click += new EventHandler(_customizeMenuItem_Click);
        }

        private void InitializeComponent() {
            this._customizeMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._toolStripSeparator = new System.Windows.Forms.ToolStripSeparator();
            // 
            // _customizeMenuItem
            // 
            this._customizeMenuItem.Name = "_customizeMenuItem";
            this._customizeMenuItem.ShortcutKeyDisplayString = "F2";
            this._customizeMenuItem.Size = new System.Drawing.Size(153, 22);
            this._customizeMenuItem.Text = "Customize";
            // 
            // _toolStripSeparator
            // 
            this._toolStripSeparator.Name = "_toolStripSeparator";
            this._toolStripSeparator.Size = new System.Drawing.Size(150, 6);
            // 
            // DisplayNamesMenuItem
            // 
            this.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._customizeMenuItem,
            this._toolStripSeparator});

        }

        protected override void OnDropDownOpening(EventArgs e) {
            CleanupDisplayNamesMenu();

            string userName = AppWorkbench.ActiveUserName;

            IEnumerable<string> displayNames = GetDisplayNames(userName);
            string currentName = Project.Current.GetDisplayName(userName);
            bool found = false;

            foreach (string displayName in displayNames) {
                ToolStripMenuItem item = (ToolStripMenuItem)DropDownItems.Add(displayName);
                item.Tag = userName;
                item.Checked = displayName == currentName;
                item.Click += new EventHandler(_displayNameMenuItem_Click);

                if (!found && item.Checked) {
                    found = true;
                }
            }

            _customizeMenuItem.Tag = userName;
            _customizeMenuItem.Checked = !found;
        }

        private static IEnumerable<string> GetDisplayNames(string userName) {
            return (from r in Project.Current.Replays
                    from s in r.Results
                    where s.UserName == userName
                    orderby s.PlayerName
                    select s.PlayerName).Distinct();
        }

        private void CleanupDisplayNamesMenu() {
            for (int i = DropDownItems.Count - 1; i >= 2; i--) {
                DropDownItems[i].Click -= _displayNameMenuItem_Click;
                DropDownItems.RemoveAt(i);
            }
        }

        private void _customizeMenuItem_Click(object sender, EventArgs e) {
            string userName = (string)((ToolStripMenuItem)sender).Tag;
            string currentName = Project.Current.GetDisplayName(userName);
            AppWorkbench.ExecuteCommand(new CustomizeDisplayNameCommand(userName, currentName));
        }

        private void _displayNameMenuItem_Click(object sender, EventArgs e) {
            ToolStripMenuItem item = (ToolStripMenuItem)sender;
            AppWorkbench.ExecuteCommand(new ChangeDisplayNameCommand((string)item.Tag, item.Text));
        }
    }
}
