﻿using System.Collections.Generic;
using System.Windows.Forms;
using LfsPoints.Projects;
using LfsPoints.Commands;

namespace LfsPoints {
    public interface IWorkbench {

        Allocation ActiveAllocation { get; }
        Replay ActiveReplay { get; }
        IEnumerable<Replay> ActiveReplays { get; }
        Result ActiveResult { get; }
        IEnumerable<Result> ActiveResults { get; }
        Standing ActiveStanding { get; }
        string ActiveUserName { get; }
        Cursor Cursor { get; set; }

        bool HandleCommandLineArgs(IEnumerable<string> commandLineArguments);
        bool ExecuteCommand(ICommand command);
        void ClearWorkbench();

        void NewProject();
        void OpenProject();
        void OpenRecentProject(string fileName);
        bool SaveProject();
        bool SaveProjectAs();
        void Close();

		void AddAllocation(Allocation allocation);
        void AddAllocation(Allocation allocation, bool selected);
        void RemoveAllocation(Allocation allocation);
        void UpdateAllocation(Allocation allocation);
        void ClearAllocations();

        void AddReplays(IEnumerable<Replay> replays);
        void AddReplay(Replay replay);
        void AddReplay(Replay replay, bool selected);
        void RemoveReplays(IEnumerable<Replay> replays);
        void UpdateReplays(IEnumerable<Replay> replays);
        void UpdateReplay(Replay replay);
        void ClearReplays();

        void UpdateResults(Replay replay);
        void UpdateResults(IEnumerable<Result> results);
        void RemoveResults(IEnumerable<Result> results);
        void ClearResults();

        void AddStandings();
        void UpdateStandings();
        void UpdateStandingDisplayName(string userName, string displayName);
        void ClearStandings();

        void ShowAbout();
    }
}
