﻿using System;
using System.Windows.Forms;
using LfsPoints.Projects;

namespace LfsPoints {
    public static class ExtensionMethods {
        public static string ToLapTimeString(this TimeSpan value) {
            if (value.Hours > 0) {
                return value.ToString(@"h\:mm\:ss\.fff");
            }
            return value.ToString(@"m\:ss\.fff");
        }

        public static string ToLapTimeString(this SerializableTimeSpan value) {
            return value.Value.ToLapTimeString();
        }

        public static int GetLastRow(this DataGridViewRowCollection collection) {
            return collection.GetLastRow(DataGridViewElementStates.None);
        }
    }
}
