﻿using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace LfsPoints {
    public static class DialogHelper {
        public static Form Owner { get; set; }

        [DebuggerStepThrough]
        public static bool ShowDialog(CommonDialog dialog) {
            return dialog.ShowDialog(Owner) == DialogResult.OK;
        }

        [DebuggerStepThrough]
        public static bool ShowDialog(Form dialog) {
            return dialog.ShowDialog(Owner) == DialogResult.OK;
        }

        [DebuggerStepThrough]
        public static void ShowError(string title, string message, params object[] args) {
            MessageBox.Show(Owner, String.Format(message, args), title, MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        [DebuggerStepThrough]
        public static void ShowInfo(string title, string message, params object[] args) {
            MessageBox.Show(Owner, String.Format(message, args), title, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        [DebuggerStepThrough]
        public static bool ShowYesNo(string title, string message, params object[] args) {
            return MessageBox.Show(Owner, String.Format(message, args), title, MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes;
        }

        [DebuggerStepThrough]
        public static DialogResult ShowYesNoCancel(string title, string message, params object[] args) {
            return MessageBox.Show(Owner, String.Format(message, args), title, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question);
        }
    }
}
