﻿using System.Linq;
using LfsPoints.Projects;
using System.Diagnostics;

namespace LfsPoints.Commands {
    public class RemoveResultsCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Result[] results = workbench.ActiveResults.ToArray();

            if (DialogHelper.ShowYesNo(
                StringResources.RemoveResultsDialogTitle,
                StringResources.RemoveResultsDialogMessage,
                results.Length)) {

                Replay replay = results.First().Replay;
                replay.Results.RemoveAll(r => results.Contains(r));
                replay.ReorderResults();

                workbench.RemoveResults(results);
                workbench.UpdateResults(replay.Results);
                workbench.UpdateReplay(replay);
                workbench.AddStandings();

                return true;
            }

            return false;
        }
    }
}
