﻿using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class RemoveReplaysCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Replay[] replays = workbench.ActiveReplays.ToArray();

            if (DialogHelper.ShowYesNo(
                StringResources.RemoveReplaysDialogTitle, 
                StringResources.RemoveReplaysDialogMessage,
                replays.Length)) {

                Project.Current.Replays.RemoveAll(r => replays.Contains(r));

                workbench.RemoveReplays(replays);
                workbench.AddStandings();

                return true;
            }

            return false;
        }
    }
}
