﻿using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class RemoveAllocationCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Allocation allocation = workbench.ActiveAllocation;

            int count = Project.Current.Replays.Count(r => r.Allocation == allocation);

            if (count > 0) {
                DialogHelper.ShowError(
                    StringResources.AllocationInUseDialogTitle,
                    StringResources.AllocationInUseDialogMessage,
                    allocation.Name,
                    count);
            }
            else if (DialogHelper.ShowYesNo(
                StringResources.RemoveAllocationDialogTitle,
                StringResources.RemoveAllocationDialogMessage,
                allocation.Name)) {
                Project.Current.Allocations.Remove(allocation);

                workbench.RemoveAllocation(allocation);

                return true;
            }

            return false;
        }
    }
}
