﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;

namespace LfsPoints.Commands {
    public class OpenLfsWorldCommand : ICommand {
        private string _userName;

        public OpenLfsWorldCommand(string userName) {
            _userName = userName;
        }

        public bool Execute(IWorkbench workbench) {
            try {
                string url = GetLfsWorldUrl(_userName);

                Process.Start(url);
            }
            catch (Win32Exception ex) {
                DialogHelper.ShowError(StringResources.OpenLfsWorldStatsErrorTitle, ex.Message);
            }
            catch (FileNotFoundException ex) {
                DialogHelper.ShowError(StringResources.OpenLfsWorldStatsErrorTitle, ex.Message);
            }

            return false;
        }

        private static string GetLfsWorldUrl(string userName) {
            return String.Format("http://www.lfsworld.net/?win=stats&racer={0}", userName);
        }
    }
}
