﻿using System;
using System.IO;
using System.Windows.Forms;
using LfsPoints.Projects;
using LfsPoints.Properties;

namespace LfsPoints.Commands {
    public class ExportAllocationCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Allocation allocation = workbench.ActiveAllocation;

            using (SaveFileDialog dialog = new SaveFileDialog()) {
                dialog.Title = "Export Points Allocation";
                dialog.Filter = "LFSPoints Points Allocation File (*.points)|*.points";
                dialog.AddExtension = true;
                dialog.OverwritePrompt = true;
                dialog.FileName = allocation.Name;
                dialog.InitialDirectory = Settings.Default.ExportDirectory;

                if (DialogHelper.ShowDialog(dialog)) {
                    try {
                        workbench.Cursor = Cursors.WaitCursor;

                        Allocation.Save(dialog.FileName, allocation);

                        Settings.Default.ExportDirectory = Path.GetDirectoryName(dialog.FileName);
                    }
                    catch (Exception ex) {
                        DialogHelper.ShowError("Error Exporting Points Allocation", ex.Message);
                    }
                    finally {
                        workbench.Cursor = null;
                    }
                }
            }

            return false;
        }
    }
}
