﻿using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class CustomizeDisplayNameCommand : ICommand {
        private string _userName;
        private string _displayName;

        public CustomizeDisplayNameCommand(string userName, string displayName) {
            _userName = userName;
            _displayName = displayName;
        }

        public bool Execute(IWorkbench workbench) {
            using (PromptDialog dlg = new PromptDialog()) {
                dlg.Title = StringResources.CustomizeDisplayNameDialogTitle;
                dlg.Caption = StringResources.CustomizeDisplayNameDialogMessage;
                dlg.Value = _displayName;

                if (DialogHelper.ShowDialog(dlg)) {
                    Project.Current.SetDisplayName(_userName, _displayName);

                    workbench.ExecuteCommand(new ChangeDisplayNameCommand(_userName, dlg.Value));
                }
            }

            return false;
        }
    }
}
