﻿using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class ChangeReplayAllocationCommand : ICommand {
        private Allocation _allocation;

        public ChangeReplayAllocationCommand(Allocation allocation) {
            _allocation = allocation;
        }

        public bool Execute(IWorkbench workbench) {
            Replay[] replays = workbench.ActiveReplays.Where(r => r.Allocation != _allocation).ToArray();

            if (replays.Any()) {
                foreach (Replay replay in replays) {
                    replay.Allocation = _allocation;
                }

                workbench.UpdateReplays(replays);
                workbench.UpdateResults(workbench.ActiveReplay);
                workbench.UpdateStandings();

                return true;
            }

            return false;
        }
    }
}
