﻿using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;
using LfsPoints.Projects;
using LfsPoints.Properties;
using System;

namespace LfsPoints.Commands {
    public class AddReplaysCommand : ICommand {
        private Allocation _allocation;

        public AddReplaysCommand(Allocation allocation) {
            _allocation = allocation;
        }

        public bool Execute(IWorkbench workbench) {
            using (OpenFileDialog dialog = new OpenFileDialog()) {
                dialog.Title = StringResources.AddReplaysDialogTitle;
                dialog.Filter = StringResources.ReplayFileFilter;
                dialog.AddExtension = true;
                dialog.Multiselect = true;
                dialog.CheckFileExists = true;
                dialog.InitialDirectory = Settings.Default.ReplayDirectory;

                if (DialogHelper.ShowDialog(dialog)) {
                    try {
                        workbench.Cursor = Cursors.WaitCursor;

                        List<Replay> replays = new List<Replay>();
                        foreach (string fileName in dialog.FileNames) {
                            Replay replay = Replay.FromFile(fileName, _allocation);

                            replays.Add(replay);

                            Project.Current.Replays.Add(replay);
                        }

                        Settings.Default.ReplayDirectory = Path.GetDirectoryName(dialog.FileName);
                        workbench.AddReplays(replays);
                        workbench.AddStandings();

                        return true;
                    }
                    catch (Exception ex) {
                        DialogHelper.ShowError(
                            StringResources.AddReplaysErrorDialogTitle,
                            StringResources.AddReplaysErrorDialogMessage,
                            ex.Message);
                    }
                    finally {
                        workbench.Cursor = null;
                    }
                }
            }

            return false;
        }
    }
}
