<?php
/**
 * PHPInSimMod - PTH Module
 * @package PRISM
 * @subpackage PTH
*/

class PTH
{
	const HEADER = 'CVersion/CRevision/lNumNodes/lFinishLine';

	public $Version;
	public $Revision;
	public $NumNodes;
	public $FinishLine;
	public $Nodes = array();

	public function __construct($pthFilePath)
	{
		$this->file = file_get_contents($pthFilePath);

		if ($this->readHeader($this->file) === TRUE)
			return; # trigger_error returns (bool) TRUE, so if the return is true, there was an error.

		for ($Node = 0; $Node < $this->NumNodes; ++$Node)
			$this->Nodes[$Node] = $this->readNode($Node);

		unset($this->file);
		
		return $this;
	}
	protected function readHeader()
	{
		if (substr($this->file, 0, 6) !== 'LFSPTH')
			return trigger_error('Not a LFS PTH file', E_USER_ERROR);
		
		foreach (unpack(PTH::HEADER, substr($this->file, 6, 10)) as $property => $value)
			$this->$property = $value;
	}
	protected function readNode($Node)
	{
		$RawNode = substr($this->file, 16 + ($Node * 40), 40);
		$NodeObj = new Node;
		$NodeObj->readCenter($RawNode);
		$NodeObj->readDirection($RawNode);
		$NodeObj->readLimit($RawNode);
		$NodeObj->readRoad($RawNode);
		return $NodeObj;
	}
}
class Node
{
	const CENTER = 'lX/lY/lZ';
	const DIRECTION = 'fX/fY/fZ';
	const LIMIT = 'fLeft/fRight';
	const ROAD = 'fLeft/fRight';

	public $Center;
	public $Direction;
	public $Limit;
	public $Road;

	public function readCenter($RawNode)
	{
		$this->Center = (object) unpack(Node::CENTER, substr($RawNode, 0, 12));
	}
	public function readDirection($RawNode)
	{
		$this->Direction = (object) unpack(Node::DIRECTION, substr($RawNode, 12, 12));
	}
	public function readLimit($RawNode)
	{
		$this->Limit = (object) unpack(Node::LIMIT, substr($RawNode, 24, 8));
	}
	public function readRoad($RawNode)
	{
		$this->Road = (object) unpack(Node::ROAD, substr($RawNode, 32, 8));
	}
	public function toPolyLimit()
	{
		return array
		(
			array
			(
				'x' => $this->Center->X + $this->Limit->Left * cos(atan2($this->Direction->X, $this->Direction->Y)) * 65536,
				'y' => $this->Center->Y - $this->Limit->Left * sin(atan2($this->Direction->X, $this->Direction->Y)) * 65536
			), array
			(
				'x' => $this->Center->X + $this->Limit->Right * cos(atan2($this->Direction->X, $this->Direction->Y)) * 65536,
				'y' => $this->Center->Y - $this->Limit->Right * sin(atan2($this->Direction->X, $this->Direction->Y)) * 65536
			)
		);
	}
	public function toPolyRoad()
	{
		return array
		(
			array
			(
				'x' => $this->Center->X + $this->Road->Left * cos(atan2($this->Direction->X, $this->Direction->Y)) * 65536,
				'y' => $this->Center->Y - $this->Road->Left * sin(atan2($this->Direction->X, $this->Direction->Y)) * 65536
			), array
			(
				'x' => $this->Center->X + $this->Road->Right * cos(atan2($this->Direction->X, $this->Direction->Y)) * 65536,
				'y' => $this->Center->Y - $this->Road->Right * sin(atan2($this->Direction->X, $this->Direction->Y)) * 65536
			)
		);
	}
}
?>