<?php
class LVS extends Plugins
{
	const URL = 'http://lfsforum.net/forumdisplay.php?f=312';
	const NAME = 'LVS';
	const AUTHOR = 'PRISM Dev Team & avetere';
	const VERSION = PHPInSimMod::VERSION;
	const DESCRIPTION = 'Lap Verification System.';

	private $Path = array();
	private $onTrack = array();

	public function __construct()
	{
		$this->registerPacket('onTrack', ISP_STA);
		$this->registerPacket('onMCI', ISP_MCI);
	}

	public function onTrack(IS_STA $STA)
	{
		static $Track;
		if ($Track == $STA->Track)
			return PLUGIN_CONTINUE;
		else
			$Track = $STA->Track;

		$file = ROOTPATH . '/data/pth/' . $Track . '.pth';

		if (!file_exists($file))
			return PLUGIN_CONTINUE;

		$pth = new PTH($file);
		$this->Path = array();
		foreach ($pth->Nodes as $NodeID => $Node)
			$this->Path[$NodeID] = $Node->toPolyRoad();
		
		console('Read track path file successfully.');
	}
	
	public function onMCI(IS_MCI $MCI)
	{
		foreach ($MCI->Info as $Info)
		{
			if ($this->isInPoly($Info->X, $Info->Y, $this->Path[$Info->Node]))
				IS_MTC()->PLID($Info->PLID)->Text('^4On Track')->Send();
			else
				IS_MTC()->PLID($Info->PLID)->Text('^1Off Track')->Send();
		}
		IS_MTC()->PLID($Info->PLID)->Text("Node {$Info->Node}: {$Info->X}, {$Info->Y} | {$this->Path[$Info->Node][0]['x']}, {$this->Path[$Info->Node][0]['y']} & {$this->Path[$Info->Node][1]['x']}, {$this->Path[$Info->Node][1]['y']}");
	}
}
?>