<?php

    class InSim {    
	
	var $socket;
	var $connected = false;
	var $connectionFailed = false;
	var $waiting_for_reply = false;
	var $alive_time = 0;
	var $conf = array();
	var $log;
	var $RACE = array();
	var $PLAYER = array();
	var $UNIQUE_ID = "";
    
	function InSim () {
	    echo "new InSim\n";
	    //$this->socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP) or die("Unable to create socket\n");
	    $this->socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP) or die("Unable to create socket\n");
	}
	
	
	function connect_to_lfs () {
	    if ($this->conf['use_relay']=="0") {
		$this->connect_to_server();
	    }
	    else {
		$this->connect_to_relay();
	    }
	}
	
	function connect_to_relay () {
	    $this->connect("isrelay.liveforspeed.net", "47474", "30");
	    // send HELLO to the Relay server
	    $this->send($this->CCN_msg(1,0,0));
	    //sleep(1);
	    $this->send($this->HOS_msg($this->conf['relay'], $this->conf['spec_pw']));
	    //$this->send($this->NLI_msg());
	    $this->send($this->VER_msg());
	    $this->send($this->SST_msg());
	}
	
	function connect_to_server () {
	    $this->connect($this->conf['host'], $this->conf['port'], "1");
	    if ($this->connected) {
		echo "sending admin password: " . $this->conf['admin_pw'] . "\n";
		$this->send($this->ISI_msg($this->conf['admin_pw']));
		$this->send($this->SST_msg());
	    }
	}
	
	function connect ($host, $port, $timeout) {
	    $this->connectionFailed = false;
	    //socket_set_nonblock($this->socket);
	    $this->log->write("connect", "try to connect");
	    $time = time();
	    socket_set_nonblock($this->socket);
		echo "trying connecting to host: $host : $port \n";
	    @socket_connect($this->socket, $host, $port);
	    socket_set_block($this->socket);
	    switch(socket_select($r = array($this->socket), $w = array($this->socket), $f = array($this->socket), 5)) {
    		case 2:
            	    echo "[-] Connection Refused\n";
		    $this->log->write("connect", "[-] Connection Refused");
		    $this->connected=false;
		    $this->connectionFailed = true;
            	    break;
    		case 1:
            	    echo "[+] Connected\n";
		    $this->log->write("connect", "[+] Connected");
		    $this->connected=true;
            	    break;
    		case 0:
            	    echo "[-] Timeout\n";
		    $this->log->write("connect", "[-] Timeout");
		    $this->connected=false;
		    $this->connectionFailed = true;
            	    break;
	    }
	    /*
	    while (!socket_connect($this->socket, $host, $port)) {
		echo $host." try\n";
    		$err = socket_last_error($this->socket);
		    if ((time() - $time) >= $timeout) {
        		socket_close($this->socket);
			$this->connected=false;
			$this->log->write("connect", "Connection timed out.");
			return 0;
    		    }
    		if ($err == 115 || $err == 114) {
    		    if ((time() - $time) >= $timeout) {
        		socket_close($this->socket);
			$this->connected=false;
			$this->log->write("connect", "Connection timed out.");
			return 0;
    		    }
    		    sleep(1);
    		    continue;
    		}
		//die(socket_strerror($err) . "\n");
	    }
	    
	    socket_set_block($this->socket);
	    echo "\nSocket Connected.\n";
	    $this->log->write("connect", "Socket Connected.");
	    $this->connected=true;
	    */
	}
	
	function disconnect () {
	    socket_close($this->socket);
	}
	
	function set_conf ($conf) {
	    $this->conf['relay'] = $conf['relay'];
	    $this->conf['host'] = $conf['host'];
	    $this->conf['port'] = $conf['port'];
	    $this->conf['admin_pw'] = $conf['admin_pw'];
	    $this->conf['spec_pw'] = $conf['spec_pw'];
	    $this->conf['use_relay'] = $conf['use_relay'];
	}
	
	function send ($msg) {
	    socket_write($this->socket, $msg);	    
	    //echo "socket_send: ".$msg." - ".strlen($msg)."\n";
	    $this->log->write("send", $msg,1);
	    //sleep(1);
	    //$err = socket_last_error($this->socket);
	    //echo socket_strerror($err) . "\n";
	}
	
	function read () {
		if ($this->can_read()) {
		    sleep(1);
		    $read = socket_read($this->socket, 16192);
		    $err = socket_last_error($this->socket);
		    socket_clear_error($this->socket);
		    if ($err>0) {
			//$read .= "ERROR-".socket_strerror($err);
			echo "ERROR-".socket_strerror($err);
		    }
		    return $read;
		}
	//    }
	}
	
	function can_read () {
	    $read = array($this->socket);
	    if(false === socket_select($read, $write = NULL, $set_e = NULL, 0, 0)){
		    $this->Error("","Socket_select() failed !\n");
		    $read = Array();
	    }
	    return $read; 
	}
	
	
	function CCN_msg ($HELLO, $REQUEST_LIST, $NO_MCI) {
	    $FLAGS = $NO_MCI*4 + $REQUEST_LIST*2 + $HELLO;
	    return "CCN".chr(0).$this->fill_string_with_null(chr($FLAGS), 4);
	}
	
	function HOS_msg ($hostname, $specpw) {
	    return "HOS".chr(0).$this->fill_string_with_null($hostname, 32).$this->fill_string_with_null($specpw, 24);
	}
	
	/*
	function ACK_msg() {
	    return "ACK".chr(0).$this->fill_string_with_null("",4);
	}
	*/
	
	function MST_msg ($msg) {
	    return  $this->to_byte(68).$this->to_byte(13).$this->to_byte(0).$this->to_byte(0).
		    $this->fill_string_with_null($msg, 64);
	}
	/*
	function MSO_msg ($msg) {
	    return "MSO".chr(0).$this->fill_string_with_null($msg, 128);
	}
	*/

	function MTC_msg ($Msg, $UCID) {
	    return $this->to_byte(72).$this->to_byte(14).chr(0).chr(0).$this->to_byte($UCID).chr(0).chr(0).chr(0).$this->fill_string_with_null($Msg, 64);
	}
	
	function GTH_msg () {
	    return $this->TINY_msg(8, 1);
	}
	
	function TINY_msg ($subt=0, $reqi=0) {
	    return $this->to_byte(4).$this->to_byte(3).$this->to_byte($reqi).$this->to_byte($subt);
	}
	
	function SMALL_msg ($subt=0, $value) {
	    return $this->to_byte(8).$this->to_byte(4).$this->to_byte(0).$this->to_byte($subt).$this->to_int($value);
	}
	
	function ISI_msg ($admin_pw="") {
	    return $this->to_byte(44).$this->to_byte(1).$this->to_byte(1).$this->to_byte(0).
		    $this->to_word(0).$this->to_word(0).$this->to_byte(0).$this->to_byte('L').$this->to_word(0).
		    $this->fill_string_with_null($admin_pw, 16).$this->fill_string_with_null('LFS-Tracker', 16);
	}
	
	
	function SST_msg () {
	    return $this->TINY_msg(7, 1);
	}
	
	function NLP_msg () {
	    return $this->TINY_msg(16, 1);
	}
	
	function NCN_msg () {
	    return $this->TINY_msg(13, 1);
	}
	function NPL_msg () {
	    return $this->TINY_msg(14, 1);
	}
	
	function NLI_msg () {
	    return $this->SMALL_msg(7, 1000);
	}
	
	function VER_msg () {
	    return $this->TINY_msg(1, 1);
	}
	
	
	function read_out_TINY ($msg) {
	    $return = array ();
	    
	    $return['ReqI'] = $this->byte($msg, 2);
	    $return['SubT'] = $this->byte($msg, 3);
	    
	    return $return;
	}


	function read_out_LAP ($msg) {
	    $return = array ();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    $return['LTime'] = $this->int($msg, 4);
	    $return['ETime'] = $this->int($msg, 8);
	    
	    $return['LapsDone'] = $this->word($msg, 12);
	    $return['Flags'] = $this->word($msg, 14);
	    
	    $return['Sp0'] = $this->byte($msg, 16);
	    $return['Penalty'] = $this->byte($msg, 17);
	    $return['NumStops'] = $this->byte($msg, 18);
	    $return['Sp3'] = $this->byte($msg, 19 );
	    
	    return $return;
	}
	

	function read_out_SPX ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    $return['STime'] = $this->int($msg, 4);
	    $return['ETime'] = $this->int($msg, 8);
	    	    
	    $return['Split'] = $this->byte($msg, 12);
	    $return['Penalty'] = $this->byte($msg, 13);
	    $return['NumStops'] = $this->byte($msg, 14);
	    $return['Sp3'] = $this->byte($msg, 15);

	    return $return;
	}
	

	function read_out_NCN ($msg) {
	    $return = array ();
	    
	    $return['UCID'] = $this->byte($msg, 3);
	    $return['UName'] = $this->char($msg, 4, 24);
	    $return['PName'] = $this->char($msg, 28, 24);
	    	    
	    $return['Admin'] = $this->byte($msg, 52);
	    $return['Total'] = $this->byte($msg, 53);
	    $return['Sp2'] = $this->byte($msg, 54);
	    $return['Sp3'] = $this->byte($msg, 55);
	    
	    return $return;
	}
	
/*	
	function read_out_REN ($msg) {
	    $return = array ();
	    
	    $return['VERIFY_ID'] = ord($msg[6])*256 + ord($msg[7]);
	    return $return;
	}
*/	
	

	function read_out_RES ($msg) { // Race Result
	    $return = array();

	    $return['PLID'] = $this->byte($msg, 3);
	    
	    $return['UName'] = $this->char($msg, 4, 24);
	    $return['PName'] = $this->char($msg, 28, 24);
	    $return['Plate'] = $this->char($msg, 52, 8);
	    $return['CName'] = $this->char($msg, 60, 4);
	    	    
	    $return['TotalTime'] = $this->msht($msg, 64);
	    $return['BestLap'] = $this->msht($msg, 68);
	    
	    $return['Hours'] = $this->byte($msg, 72);
	    $return['NumStops'] = $this->byte($msg, 73);
	    $return['Confirm'] = $this->byte($msg, 74);
	    $return['SpB'] = $this->byte($msg, 75);
	    
	    $return['LapsDone'] = $this->word($msg, 76);
	    $return['Flags'] = $this->word($msg, 78);
	    
	    $return['ResultNum'] = $this->byte($msg, 80);
	    $return['NumRes'] = $this->byte($msg, 81);
	    $return['PSeconds'] = $this->word($msg, 82);
	    $return['Sp3'] = $this->byte($msg, 83);

	    return $return;
	}
	
		
	function read_out_RST ($msg) { // Race Start
	    $return = array ();
	    
	    $return['RaceLaps'] = $this->byte($msg, 4);
	    $return['QualMins'] = $this->byte($msg, 5);
	    $return['NumP'] = $this->byte($msg, 6);
	    $return['Spare'] = $this->byte($msg, 7);
	    
	    $return['Track'] = $this->char($msg, 8, 6);
	    $return['Weather'] = $this->byte($msg, 14);
	    $return['Wind'] = $this->byte($msg, 15);
	    	    
	    $return['Flags'] = $this->word($msg, 16);
	    $return['NumNodes'] = $this->word($msg, 18);
	    $return['Finish'] = $this->word($msg, 20);
	    $return['Split1'] = $this->word($msg, 22);
	    $return['Split2'] = $this->word($msg, 24);
	    $return['Split3'] = $this->word($msg, 26);
	    
	    return $return;
	}



	function read_out_MCI ($msg) { // MCI PACK
	    $return = array ();
	    
	    $return['NumC'] = $this->byte($msg, 3);
	    $s = 4;
	    for ($i=0 ; $i<$return['NumC'] ; $i++) {
		$st = $i*28+$s;
		$j = $i;
		$return[$j.'_Node'] = $this->word($msg, $st+0);
		$return[$j.'_Lap'] = $this->word($msg, $st+2);
		$return[$j.'_UniqueID'] = $this->byte($msg, $st+4);
		$return[$j.'_Sp1'] = $this->byte($msg, $st+5);
		$return[$j.'_Sp2'] = $this->byte($msg, $st+6);
		$return[$j.'_Sp3'] = $this->byte($msg, $st+7);		
		$return[$j.'_X'] = $this->int($msg, $st+8);
		$return[$j.'_Y'] = $this->int($msg, $st+12);
		$return[$j.'_Z'] = $this->int($msg, $st+16);
		$return[$j.'_Speed'] = $this->word($msg, $st+20);
		$return[$j.'_Direction'] = $this->word($msg, $st+22);
		$return[$j.'_Heading'] = $this->word($msg, $st+24);
		$return[$j.'_AngVel'] = $this->word($msg, $st+26);
	    }

	    return $return;
	}

	function read_out_NLP ($msg) { // NLP PACK
	    $return = array ();
	    
	    $return['NumP'] = $this->byte($msg, 3);
	    $s = 4;
	    for ($i=0 ; $i<$return['NumP'] ; $i++) {
		$st = $i*4+$s;
		$j = $i;
		$return[$j.'_NodeLapHi3'] = $this->word($msg, $st+0);
		$return[$j.'_LapLo8'] = $this->byte($msg, $st+2);
		$return[$j.'_UniqueId'] = $this->byte($msg, $st+3);
	    }

	    return $return;
	}


	function read_out_STA ($msg) {
	    $return = array();
	    	    
	    $return['ReplaySpeed'] = $this->char($msg, 4, 4);
	    
	    $return['Flags'] = decbin($this->word($msg, 8));
	    $return['InGameCam'] = $this->byte($msg, 10);
	    $return['ViewPlayer'] = $this->byte($msg, 11);
	    
	    $return['NumP'] = $this->byte($msg, 12);
	    $return['NumConns'] = $this->byte($msg, 13);
	    $return['NumFinished'] = $this->byte($msg, 14);
	    $return['RaceInProg'] = $this->byte($msg, 15);
	    
	    $return['QualMins'] = $this->byte($msg, 16);
	    $return['RaceLaps'] = $this->byte($msg, 17);
	    $return['Spare2'] = $this->byte($msg, 18);
	    $return['Spare3'] = $this->byte($msg, 19);
	    
	    $return['Track'] = $this->char($msg, 20, 6);
	    $return['Weather'] = $this->byte($msg, 26);
	    $return['Wind'] = $this->byte($msg, 27);
	    
	    return $return;
	}


	function read_out_MSO ($msg) {
	    $return = array();
	    
	    $return['UCID'] = $this->byte($msg, 4);
	    $return['PLID'] = $this->byte($msg, 5);
	    $return['User'] = $this->byte($msg, 6);
	    $return['TextStart'] = $this->byte($msg, 7);
	    
	    $return['Msg'] = $this->char($msg, 8, 128);
	    
	    return $return;
	}
	
	function read_out_PLP ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    return $return;
	}

	function read_out_PLL ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    return $return;
	}
    
   	function read_out_CRS ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    return $return;
	}
	
	
	function read_out_CNL ($msg) {
	    $return = array();
	    
	    $return['UCID'] = $this->byte($msg, 3);

	    $return['Sp0'] = $this->byte($msg, 4);
	    $return['Total'] = $this->byte($msg, 5);
	    $return['Sp2'] = $this->byte($msg, 6);
	    $return['Sp3'] = $this->byte($msg, 7);
	    
	    return $return;
	}
	
	function read_out_PLA ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);

	    $return['Fact'] = $this->byte($msg, 4);
	    $return['Sp1'] = $this->byte($msg, 5);
	    $return['Sp2'] = $this->byte($msg, 6);
	    $return['Sp3'] = $this->byte($msg, 7);
	    
	    return $return;
	}
	
	function read_out_TOC ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);

	    $return['OldUCID'] = $this->byte($msg, 4);
	    $return['NewUCID'] = $this->byte($msg, 5);
	    $return['SP2'] = $this->byte($msg, 6);
	    $return['Sp3'] = $this->byte($msg, 7);
	    
	    return $return;
	}

	function read_out_FLG ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);

	    $return['OffOn'] = $this->byte($msg, 4);
	    $return['Flag'] = $this->byte($msg, 5);
	    $return['CarBehind'] = $this->byte($msg, 6);
	    $return['Sp3'] = $this->byte($msg, 7);
	    
	    return $return;
	}


	function read_out_NPL ($msg) {
	    $return = array();
	    
	    $return['PLID'] = $this->byte($msg, 3);
	    
	    $return['UCID'] = $this->byte($msg, 4);
	    $return['PType'] = $this->byte($msg, 5);
	    $return['Flags'] = $this->word($msg, 6);
	    
	    $return['PName'] = $this->char($msg, 8, 24);
	    $return['Plate'] = $this->char($msg, 32, 8);
	    
	    $return['CName'] = $this->char($msg, 40, 4);
	    $return['SName'] = $this->char($msg, 44, 16);
	    $return['Tyres1'] = $this->byte($msg, 60);
	    $return['Tyres2'] = $this->byte($msg, 61);
	    $return['Tyres3'] = $this->byte($msg, 62);
	    $return['Tyres4'] = $this->byte($msg, 63);
	    
	    $return['H_Mass'] = $this->byte($msg, 64);
	    $return['H_TRes'] = $this->byte($msg, 65);
	    $return['SpB'] = $this->byte($msg, 66);
	    $return['Pass'] = $this->byte($msg, 67);
	    
	    $return['Spare'] = $this->int($msg, 68);
	    
	    $return['Sp0'] = $this->byte($msg, 72);
	    $return['NumP'] = $this->byte($msg, 73);
	    $return['Sp2'] = $this->byte($msg, 74);
	    $return['Sp3'] = $this->byte($msg, 75);
	    
	    
	    return $return;
	}
	
/*
	function read_out_RTP ($msg) {
	    $return = array();
	    
	    $return['TIME'] = $this->int($msg, 4);
	    
	    return $return;
	}
*/	


	function read_out_VER ($msg) {
	    $return = array();
	    
	    $return['Version'] = $this->char($msg, 4, 8);
	    $return['Product'] = $this->char($msg, 12, 6);
	    $return['InSimVer'] = $this->word($msg, 18);
	    
	    return $return;
	}
		
	
	function fill_string_with_null ($string, $strlen) {
	    $RETURN = "";
	    $sl = strlen($string);
	    for ($i=0;$i<$strlen;$i++)
		if ($i>$sl-1)
		    $RETURN .= chr(0);
		else 
		    $RETURN .= $string[$i];
	    return $RETURN;
	}
	
	
	function char ($msg, $start, $count) {
	    return trim(substr($msg, $start, $count));
	}
	
	function byte ($msg, $start) {
	    return ord($msg[$start]);
	}
	
	function word ($msg, $start) {
	    return ord($msg[$start+1])*256 + ord($msg[$start]);
	}
	
	function int ($msg, $start) {
	    return (ord($msg[$start+3])<<24) | (ord($msg[$start+2]) << 16) | (ord($msg[$start+1]) << 8) | ord($msg[$start]);
	}
	
	function msht ($msg, $start) {
	    return $this->time_StrToInt(ord($msg[$start]).":".lz(ord($msg[$start+1])).".".lz(ord($msg[$start+2])).lz(ord($msg[$start+3])));
	}
	
	function to_word($val) {
	    $high = floor($val / 256);
	    $low = $val % 256;
	    return chr($low).chr($high);
	}
	
	function to_int($val) {
	    return pack('i', intval($val));
	}
	
	
	function to_byte ($val) {
	    return chr($val);
	}

	function time_StrToInt ($time) {
	    $time_old = $time;
	    $time_new = array();
	    $x = preg_match("/([0-9]+)\:([0-9]+)\.([0-9]+)/", $time, $time_new);
	    $time = $time_new;
	    if (strlen($time[3])<3) {
		$time[3].="0";
	    }
	    elseif (strlen($time[3])>3) {
		$time[3] = substr($time[3], 0, 3);
	    }
	    $time = $time[1]*60*1000 + $time[2]*1000 + $time[3];
	    $result = substr($time, 0, strlen($time)-1);
	    //    echo "time_StrToInt ".$time_old." = ".$result."\n";
	    return $result;
	}

	function calc_time($time) {
	    $time = abs($time);
	    $m = floor($time/60/1000);
	    
	    $s = floor(($time-($m * 1000 * 60))/1000);
	    $t = ($time-(($m * 1000 * 60)+($s*1000)));
	    if ($s<10) $s="0".$s;
	    if ($t==0) $t="000";
	    elseif ($t<10) $t="00".$t;
	    elseif ($t<100) $t="0".$t;
	    return $m.":".$s.".".$t;
	}



    }


?>
