<?php

function get_strings_from( $filename ) {

    $set = array();
    if (file_exists($filename) && $fp=fopen($filename,"r")) {
	for ($i=0;!feof($fp);$i++) {
	    $line = fgets( $fp, 512 );
	    if (!preg_match("/^#/",$line) && preg_match("/~>/",$line)) {
		$assignment = explode("~>",$line);
		$set[trim($assignment[0])] = trim($assignment[1]);
	    }
	}
	fclose($fp);
    }

    return $set;
}

function lz ($num) { // leading zero
    return $num<10 ? "0".$num : $num;    
}



function read_file ($file) {
    $CONTENT = '';
    $fp = @fopen($file, "r");
    if ($fp) {
        while (!feof($fp)) {
            $CONTENT .= fgets($fp, 4096);
        }
        fclose($fp);
    }
    return $CONTENT;
}

function write_file ($file, $CONTENT, $BOM=false) {
    $fp = @fopen($file, "w");
    if ($fp) {
        if ($BOM)
            fwrite($fp, chr(hexdec('EF')).chr(hexdec('BB')).chr(hexdec('BF')).$CONTENT);
        else
            fwrite($fp, $CONTENT);
        fclose($fp);
    }
}

function setServerOnline ($server, $status) {
    $_server = get_strings_from( '../conf/server.online' );
    $_server[$server] = $status;
    write_strings_in('../conf/server.online', $_server);
}

function write_strings_in ($file, $strings) {
    $content = '';
    foreach ($strings as $key => $val) {
	$content .= $key.'  ~>  '.$val."\n";
    }
    write_file($file, $content);
}


?>
