<?php
class TimingAndScoring extends Plugins
{
	const URL = 'http://lfsforum.net/forumdisplay.php?f=312';
	const NAME = 'Timing & Scoring';
	const AUTHOR = 'Mark \'Dygear\' Tomlin';
	const VERSION = '0.2.0';
	const DESCRIPTION = 'Formula One Managaement Style Timeing & Scoring';

	public function __construct()
	{
		// Registered Packets.
		# Time & Scoring
		$this->registerPacket('onSplit', ISP_LAP, ISP_SPX);
		$this->registerPacket('onResult', ISP_RES);
		$this->registerPacket('onFinished', ISP_FIN);
		$this->registerPacket('onVerification', ISP_HLV);
		# Player Tracking
		$this->registerPacket('onPlayerChange', ISP_NPL, ISP_PLL);

		# Say Commands
		$this->registerSayCommand('t&s best', 'onCmd', 'Returns current best sectors.');
	}

	private $Splits = array();

	public function OSD($PLID, $Split, $Pace, $STime, $BTime)
	{
		$Symbol = (($Delta = $STime - $BTime) < 0) ? '-' : '+';
		$Client = $this->getClientByPLID($PLID);
	
		$bName = new Button($Client->UCID, 'PName', 'FOM');
		$bName->L(40)->T(166)->W(40)->H(8);
		$bName->BStyle |= ISB_DARK + ISB_RIGHT;
		$bName->Text($Client->PName)->send();
	
		$bTime = new Button($Client->UCID, 'STime', 'FOM');
		$bTime->L(40)->T(174)->W(40)->H(8);
		$bTime->BStyle |= ISB_DARK + ISB_RIGHT;
		$bTime->Text($Pace . timeToStr($STime))->send();
	
		$bDelta = new Button($Client->UCID, 'Delta', 'FOM');
		$bDelta->L(40)->T(182)->W(40)->H(8);
		$bDelta->BStyle |= ISB_DARK + ISB_RIGHT;
		$bDelta->Text((($Symbol == '-') ? '^2' : '^3') . $Symbol . timeToStr(abs($Delta)))->send();
	
	#	$bPlace = new Button($Client->UCID, 'Place', 'FOM');
	#	$bPlace->L(80)->T(166)->W(16)->H(16);
	#	$bPlace->BStyle |= ISB_LIGHT;
	#	$bPlace->Text('^11')->send();
	
		$this->createTimer('OSR', 10, Timer::CLOSE, array($Client->UCID));
	}

	public function OSR($UCID)
	{
		ButtonManager::removeButtonsByGroup($UCID, 'FOM');
	}

	// Packet Interfaces
	# Lap & Sector
	public function onSplit(Struct $SLP)
	{
		# Generalize
		$Time = ($SLP instanceof IS_LAP) ? 'LTime' : 'STime';
		$Split = ($SLP instanceof IS_LAP) ? 'LAP' : 'SP'.$SLP->Split;
		$Delta = (isset($this->Splits[$Split])) ? $this->Splits[$Split] : $SLP->$Time;

		# Color Setup
		$Color = '';
		if (!isset($this->Splits[$SLP->PLID][$Split]) OR $SLP->$Time < $this->Splits[$SLP->PLID][$Split]) {
			$Color = '^2';
			$this->Splits[$SLP->PLID][$Split] = $SLP->$Time;
		}
		if (!isset($this->Splits[$Split]) OR $SLP->$Time < $this->Splits[$Split]) {
			$Color = '^5';
			$this->Splits[$Split] = $SLP->$Time;
		}
		$Str = $Color . timeToString($SLP->$Time);

		# Send Message
		IS_MSX()->Msg($Str)->Send();
		# On Screen Display
		$this->OSD($SLP->PLID, $Split, $Color, $SLP->$Time, $Delta);
	}
	# Results Provisional
	public function onResult(IS_RES $RES)
	{
		print_r($RES);
	}
	# Results Final
	public function onFinished(IS_FIN $FIN)
	{
		print_r($FIN);
	}
	# Player Tracking
	public function onPlayerChange(Struct $PLY)
	{
		print_r($PLY);
	}
	public function onVerification(IS_HLV $HLV)
	{
		print_r($HLV);
	}
}
?>