<?
# poll-lfs.php
#
# Check lfsworld for information on a specific dedicated host
# and commit database
#


#HOSTNAME        char[32]
#TCRM            byte[4] // Track, Config, Reversed, Max players allowed
#LAPS            byte [1]
#NROFRACERS      byte[1]
#
#LAPS work like this:
#    L is the given Laps value
#    0=practice
#    1-100=laps
#    101-190=110-1000 laps...  100+(L-100)*10
#    191-238=1-48 hours... L-190
#
#(*) TRC is in numbers:
#000 = bl1
#001 = bl1r
#010 = bl2
#..
#220 = fe3
#221 = fe3r
#etc.
# 


###############################################
# CONFIGURATION
###############################################
#
#
# database details
require_once('dbconfig.php');

# Servername you want information for
$my_host = "";

# get the hostlist
$hostlist = file_get_contents ("http://lfsworld.net/pubstat/get_stat2.php?action=hosts");
$len = strlen ($hostlist);
if ($len < 52) $server_status = "Down"; 

$x = 0;
$track_info = "none";

# parse the data
while ($x < $len - 52) {
	$hostname = "";
	$nr_racers = 0;
	$laps = 0;
	$max_field = 0;

    for ($y=0; $y<32; $y++) $hostname .= $hostlist[$x++];
    $hostname = remove_colour_codes ($hostname);	
    $hostname = trim_c_string ($hostname);

	// Process the target host information
	if ( $hostname == $my_host) {
		
		$server_status = "Up";
		
		//printf ("Server Name: %s\n", $hostname);
		
		$x +=4; // process TCRM
		$track_code = "";
		
		for ($y=0; $y<3; $y++) $track_code .= ord ($hostlist[$x++]);
		$track_info = get_track_info($track_code);
		//printf ("Track: %s\n", $track_info);
		
		$max_field = $hostlist[$x++];
        //printf ("Max Field: %d\n", ord ($max_field));
		
		$x += 8; // process Laps
		$laps =  ord ($hostlist[$x++]);
        //printf ("Laps: %d\n", $laps);

		$x += 3; // Process nr_racers 
    	$nr_racers = $hostlist[$x++];
        //printf ("racers online: %d\n", $nr_racers);

		commit ($dbname, $my_host, $track_info, $nr_racers, $max_field, $laps, 0);
		exit;
	}
	$x += 20;
	$nr_racers = ord ($hostlist[$x++]);
	$x += $nr_racers * 24;
}
if ($track_info == "none") {
	commit ($dbname, $my_host, $track_info, $nr_racers, $max_field, $laps, 1);
}
exit;



function commit ($dbname, $my_host, $track_info, $nr_racers, $max_field, $laps, $status) {

	# Connect to the database (see dbconfig.php)
	$db = getDBConnection();
	if (!$db) {
        echo 'Error: Unable to connect to Database';
        exit;
	}
	mysql_select_db($dbname, $db);

	if ( $status == 0 ) {
		$sql_command = 'UPDATE lfs_mon SET Server_Name = "'.$my_host.'", Server_Track = "'.$track_info.'", Players_On = "'.$nr_racers.'", Players_Max = "'.$max_field.'", Race_Laps = "'.$laps.'";';

		# comit to database
		$sql_result = mysql_query($sql_command, $db);
		if (!$sql_result) {
    		echo mysql_errno($db) . ": " . mysql_error($db). "\n";
    		return;
		}
	} else {
		$sql_command = 'UPDATE lfs_mon SET Server_Name = "'.$my_host.'", Server_Track = "N/A", Players_On = "0", Players_Max = "0", Race_Laps = "0";';
		# comit to database
        $sql_result = mysql_query($sql_command, $db);
        if (!$sql_result) {
            echo mysql_errno($db) . ": " . mysql_error($db). "\n";
            return;
        }
	}
}




# function to safely trim null-terminated strings
# could just use trim () in this example though
function trim_c_string ($string) {
    $new = "";
    $len = strlen ($string);
    for ($x=0; $x<$len; $x++) {
        if ($string[$x] != "\0") $new .= $string[$x];
        else break;
    }
    return $new;
} 

# Function to remove the colour code data from a string
function remove_colour_codes($String){
	$ColCodes = array("^0","^1","^2","^3","^4","^5","^6","^7","^8","^9");
	$NewString = str_replace($ColCodes, "",$String);
	return $NewString;
}


function get_track_info($code) {

	switch ($code) {

	case "000":
		return "Blackwood GP";
   		break;
	case "001":
		return "Blackwood GP Rev.";
   		break;
	case "010":
		return "Blackwood RallyX";
   		break;
	case "011":
		return "Blackwood RallyX Rev";
   		break;
	case "020":
		return "Blackwood AutoX";
   		break;
	
	case "100":
		return "S. City Classic";
   		break;
	case "101":
		return "S. City Classic Rev.";
   		break;
	case "110":
		return "S. City Sprint 1";
   		break;
	case "111":
		return "S. City Sprint 1 Rev.";
   		break;
	case "120":
		return "S. City Sprint 2";
   		break;
	case "121":
		return "S. City Sprint 2 Rev.";
   		break;
	case "130":
		return "S. City Long";
   		break;
	case "131":
		return "S. City Long Rev.";
   		break;
	case "140":
		return "S. City Town Course";
   		break;
	case "141":
		return "S. City Town Course Rev.";
   		break;

	case "200":
		return "Fern Bay Club";
		break;
	case "201":
		return "Fern Bay Club Rev.";
		break;
	case "210":
		return "Fern Bay Green";
		break;
	case "211":
		return "Fern Bay Green Rev.";
		break;
	case "220":
		return "Fern Bay Gold";
		break;
	case "221":
		return "Fern Bay Gold Rev.";
		break;
	case "230":
		return "Fern Bay Black";
		break;
	case "231":
		return "Fern Bay Black Rev.";
		break;
	case "240":
		return "Fern Bay RallyX";
		break;
	case "241":
		return "Fern Bay RallyX Rev.";
		break;
	case "250":
		return "Fern Bay RallyX Green";
		break;
	case "251":
		return "Fern Bay RallyX Green Rev.";
		break;

	case "300":
		return "Autocross";
		break;
	case "310":
		return "Skid Pad";
		break;
	case "320":
		return "Drag Dtrip";
		break;
	case "330":
		return "Eight Lane Drag";
		break;

	case "400":
		return "Kyoto Oval";
		break;
	case "401":
		return "Kyoto Oval Rev.";
		break;
	case "410":
		return "Kyoto Naitonal";
		break;
	case "411":
		return "Kyoto National Rev.";
		break;
	case "420":
		return "Kyoto GP Long";
		break;
	case "421":
		return "Kyoto GP Long Rev.";
		break;

	case "500":
		return "West Hill Int.";
		break;
	case "501":
		return "West Hill Int. Rev.";
		break;

	case "600":
		return "Aston Cadet";
		break;
	case "601":
		return "Aston Cadet Rev.";
		break;
	case "610":
		return "Aston Club";
		break;
	case "611":
		return "Aston Club Rev.";
		break;
	case "620":
		return "Aston National";
		break;
	case "621":
		return "Aston National Rev.";
		break;
	case "630":
		return "Aston Historic";
		break;
	case "631":
		return "Aston Historic Rev.";
		break;
	case "640":
		return "Aston GP";
		break;
	case "641":
		return "Aston GP Rev.";
		break;
	case "650":
		return "Aston Touring";
		break;
	case "651":
		return "Aston Touring Rev.";
		break;
	case "660":
		return "Aston North";
		break;
	case "661":
		return "Aston North Rev.";
		break;
	}
}
?>

