#pragma once
#ifndef _WHEELINTERFACE_H_
#define _WHEELINTERFACE_H_

#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>
#include <string>

class WheelInterface
{
public:
	WheelInterface();
	~WheelInterface(void);
	HRESULT InitDirectInput(void);
	void SendLeds(int, int, int, bool);

	LPDIRECTINPUT8 di;
	LPDIRECTINPUTDEVICE8 diDevice;
	bool deviceFound;

private:
	std::string TranslateError(HRESULT, std::string&);

	struct LedsRpmData
	{
		float currentRPM;
		float rpmFirstLedTurnsOn;
		float rpmRedLine;
	};
	struct WheelData
	{
		DWORD size;
		DWORD versionNbr;
		LedsRpmData rpmData;
	};
};

static BOOL CALLBACK DevEnumCallBack(const DIDEVICEINSTANCE*, VOID*);
#endif